/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.filesystem;

import io.github.codejanovic.java.filesearch.filesystem.Attributes;
import io.github.codejanovic.java.filesearch.filesystem.FileEntry;
import io.github.codejanovic.java.filesearch.filesystem.attributes.Cached;
import io.github.codejanovic.java.filesearch.filesystem.attributes.FollowLinks;
import io.github.codejanovic.java.filesearch.filesystem.attributes.NoFollowLinksFallback;
import io.github.codejanovic.java.filesearch.iterator.CloseableIterator;
import io.github.codejanovic.java.filesearch.iterator.path.DirectoryIterator;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;

public interface Directory
extends FileEntry {
    public CloseableIterator<Path> iterator();

    public DirectoryStream<Path> open() throws IOException;

    public static final class Smart
    implements Directory {
        private final FileEntry fileEntry;

        public Smart(FileEntry fileEntry) {
            this.fileEntry = fileEntry;
        }

        public Smart(Path path) {
            this(new FileEntry.Smart(path, new Cached(new NoFollowLinksFallback(new FollowLinks(path)))));
        }

        @Override
        public Path path() {
            return this.fileEntry.path();
        }

        @Override
        public Attributes attributes() {
            return this.fileEntry.attributes();
        }

        @Override
        public Object uniqueKey() {
            return this.fileEntry.uniqueKey();
        }

        @Override
        public boolean valid() {
            return this.fileEntry.valid();
        }

        @Override
        public boolean isFile() {
            return this.fileEntry.isFile();
        }

        @Override
        public boolean isDirectory() {
            return this.fileEntry.isDirectory();
        }

        @Override
        public DirectoryStream<Path> open() throws IOException {
            return Files.newDirectoryStream(this.fileEntry.path());
        }

        @Override
        public CloseableIterator<Path> iterator() {
            return new DirectoryIterator(this);
        }

        public boolean equals(Object o) {
            return this.fileEntry.equals(o);
        }

        public int hashCode() {
            return this.fileEntry.hashCode();
        }
    }
}

