/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.filesystem;

import io.github.codejanovic.java.filesearch.filesystem.Attributes;
import io.github.codejanovic.java.filesearch.filesystem.attributes.Cached;
import io.github.codejanovic.java.filesearch.filesystem.attributes.FollowLinks;
import io.github.codejanovic.java.filesearch.filesystem.attributes.NoFollowLinksFallback;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public interface FileEntry {
    public Path path();

    public Attributes attributes();

    public Object uniqueKey();

    public boolean valid();

    public boolean isFile();

    public boolean isDirectory();

    public static final class Smart
    implements FileEntry {
        private final Path path;
        private final Attributes attributes;

        public Smart(Path path, Attributes attributes) {
            this.path = path;
            this.attributes = attributes;
        }

        public Smart(Path path) {
            this(path, new Cached(new NoFollowLinksFallback(new FollowLinks(path))));
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public Attributes attributes() {
            return this.attributes;
        }

        @Override
        public Object uniqueKey() {
            try {
                return this.attributes().load().fileKey();
            }
            catch (IOException e) {
                return null;
            }
        }

        private boolean isSame(FileEntry file) {
            try {
                return Files.isSameFile(this.path(), file.path());
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public boolean valid() {
            try {
                this.attributes.load();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public boolean isFile() {
            try {
                return this.attributes.load().isRegularFile();
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public boolean isDirectory() {
            try {
                return this.attributes.load().isDirectory();
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileEntry aSmart = (FileEntry)o;
            if (this.uniqueKey() == null || aSmart.uniqueKey() == null) {
                return this.isSame(aSmart);
            }
            return this.uniqueKey() != null ? this.uniqueKey().equals(aSmart.uniqueKey()) : false;
        }

        public int hashCode() {
            return this.uniqueKey() != null ? this.uniqueKey().hashCode() : this.path.hashCode();
        }
    }
}

