/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.filesystem.attributes;

import io.github.codejanovic.java.filesearch.filesystem.Attributes;
import io.github.codejanovic.java.filesearch.filesystem.attributes.NoFollowLinks;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public final class NoFollowLinksFallback
implements Attributes {
    private final Attributes attributes;
    private final Attributes noFollowAttributes;

    public NoFollowLinksFallback(Attributes attributes, Attributes noFollowAttributes) {
        this.attributes = attributes;
        this.noFollowAttributes = noFollowAttributes;
    }

    public NoFollowLinksFallback(Attributes attributes) {
        this(attributes, new NoFollowLinks(attributes.path()));
    }

    @Override
    public Path path() {
        return this.attributes.path();
    }

    @Override
    public boolean followLinks() {
        return false;
    }

    @Override
    public BasicFileAttributes load() throws IOException {
        try {
            return this.attributes.load();
        }
        catch (IOException e) {
            return this.noFollowAttributes.load();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoFollowLinksFallback that = (NoFollowLinksFallback)o;
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        return this.noFollowAttributes != null ? this.noFollowAttributes.equals(that.noFollowAttributes) : that.noFollowAttributes == null;
    }

    public int hashCode() {
        int result = this.attributes != null ? this.attributes.hashCode() : 0;
        result = 31 * result + (this.noFollowAttributes != null ? this.noFollowAttributes.hashCode() : 0);
        return result;
    }
}

