/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.filesearch.iterator.path;

import io.github.codejanovic.java.filesearch.filesystem.Directory;
import io.github.codejanovic.java.filesearch.filesystem.FileEntry;
import io.github.codejanovic.java.filesearch.iterator.RepeatableIterator;
import io.github.codejanovic.java.filesearch.iterator.path.DirectoryIterator;
import io.github.codejanovic.java.filesearch.iterator.path.FilePathIterator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Stack;

public class RecursiveSilentDirectoryIterator
implements Iterator<Path> {
    private final Stack<RepeatableIterator<Path>> iteratorStack = new Stack();
    private RepeatableIterator<Path> iterator;

    public RecursiveSilentDirectoryIterator(FileEntry start) {
        this.iterator = start.isDirectory() ? new RepeatableIterator.Closeable<Path>(new DirectoryIterator(new Directory.Smart(start))) : new RepeatableIterator.Smart<Path>(new FilePathIterator(start));
    }

    @Override
    public boolean hasNext() {
        if (this.givenCurrentPath()) {
            if (this.loopIsDetected()) {
                this.skipDirectory();
            } else {
                this.openDirectory();
            }
        }
        if (this.givenNoNextEntry() && this.whenThereAreQueuedPaths()) {
            this.thenDequeueThosePathsUntilThereIsANextEntryOrNoPathsLeft();
        }
        return this.iterator.hasNext();
    }

    private void skipDirectory() {
    }

    private boolean loopIsDetected() {
        FileEntry.Smart current = new FileEntry.Smart(this.iterator.current());
        if (!current.isDirectory()) {
            return false;
        }
        for (RepeatableIterator repeatableIterator : this.iteratorStack) {
            if (!new FileEntry.Smart((Path)repeatableIterator.current()).equals(current)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Path next() {
        return (Path)this.iterator.next();
    }

    private boolean givenCurrentPath() {
        return this.iterator.hasCurrent();
    }

    private void thenDequeueThosePathsUntilThereIsANextEntryOrNoPathsLeft() {
        while (this.givenNoNextEntry()) {
            this.closeDirectorySilently(this.iterator);
            if (this.whenThereAreQueuedPaths()) {
                this.iterator = this.iteratorStack.pop();
                continue;
            }
            return;
        }
    }

    private boolean whenThereAreQueuedPaths() {
        return !this.iteratorStack.isEmpty();
    }

    private boolean givenNoNextEntry() {
        return !this.iterator.hasNext();
    }

    private void openDirectory() {
        FileEntry.Smart current = new FileEntry.Smart(this.iterator.current());
        if (!current.isDirectory()) {
            return;
        }
        this.openDirectoryIfItIsNotEmpty(current);
    }

    private void openDirectoryIfItIsNotEmpty(FileEntry current) {
        RepeatableIterator.Closeable<Path> currentDirectoryIterator = new RepeatableIterator.Closeable<Path>(new DirectoryIterator(new Directory.Smart(current)));
        if (currentDirectoryIterator.hasNext()) {
            this.iteratorStack.push(this.iterator);
            this.iterator = currentDirectoryIterator;
        } else {
            this.closeDirectorySilently(currentDirectoryIterator);
        }
    }

    private void closeDirectorySilently(Iterator<Path> iterator) {
        try {
            if (iterator instanceof Closeable) {
                ((Closeable)((Object)iterator)).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

