/*
 * Decompiled with CFR 0.152.
 */
package io.github.createduser.lang_string;

import io.github.createduser.lang_string.BaseLang;
import io.github.createduser.lang_string.MatchPriority;
import io.github.createduser.lang_string.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\b\"\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002JS\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u00032#\b\u0002\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00030\u001fJ\u0011\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0086\u0002J\u0013\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00030)J\u0006\u0010*\u001a\u00020\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lio/github/createduser/lang_string/Lang;", "", "lang", "", "dialect", "script", "region", "privates", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "()V", "index", "", "getBaseLang", "Lio/github/createduser/lang_string/BaseLang;", "toString", "hashCode", "equals", "", "other", "joinToString", "priority", "Lio/github/createduser/lang_string/MatchPriority;", "separator", "prefix", "postfix", "transform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "str", "get", "tag", "Lio/github/createduser/lang_string/Tag;", "getPrivates", "()[Ljava/lang/String;", "toMutableMap", "", "toLocale", "Companion", "LanguageString"})
@SourceDebugExtension(value={"SMAP\nLang.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lang.kt\nio/github/createduser/lang_string/Lang\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class Lang {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int index;
    @NotNull
    private static List<BaseLang> baseLangs;

    /*
     * WARNING - void declaration
     */
    public Lang(@NotNull String lang, @NotNull String dialect, @NotNull String script, @NotNull String region, String ... privates) {
        String string;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        Intrinsics.checkNotNullParameter((Object)privates, (String)"privates");
        String string2 = lang.toLowerCase(Locale.ROOT);
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string4 = dialect.toLowerCase(Locale.ROOT);
        String string5 = string4;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String string6 = script.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        String string7 = string6;
        if (((CharSequence)string7).length() > 0) {
            void it;
            char c = string7.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            String string8 = string5;
            String string9 = string3;
            boolean bl = false;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            CharSequence charSequence = CharsKt.titlecase((char)it, (Locale)locale);
            string3 = string9;
            string5 = string8;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
            String string10 = string7;
            int n = 1;
            String string11 = string10.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"substring(...)");
            string = stringBuilder2.append(string11).toString();
        } else {
            string = string7;
        }
        String string12 = region.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toUpperCase(...)");
        String[] stringArray = privates;
        String string13 = string12;
        String string14 = string;
        String string15 = string5;
        String string16 = string3;
        BaseLang baseLang = new BaseLang(string16, string15, string14, string13, stringArray);
        if (!baseLangs.contains(baseLang)) {
            baseLangs.add(baseLang);
        }
        this.index = baseLangs.indexOf(baseLang);
    }

    public /* synthetic */ Lang(String string, String string2, String string3, String string4, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        this(string, string2, string3, string4, stringArray);
    }

    public Lang(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = locale.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        String string2 = locale.getVariant();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVariant(...)");
        String string3 = locale.getScript();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getScript(...)");
        String string4 = locale.getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCountry(...)");
        this(string, string2, string3, string4, new String[0]);
    }

    public Lang() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        this(locale);
    }

    private final BaseLang getBaseLang() {
        return baseLangs.get(this.index);
    }

    @NotNull
    public String toString() {
        return Lang.joinToString$default(this, null, null, null, null, null, 31, null);
    }

    public int hashCode() {
        return this.index * 85;
    }

    public boolean equals(@Nullable Object other) {
        try {
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.github.createduser.lang_string.Lang");
            Lang otherLang = (Lang)other;
            return this.index == otherLang.index;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public final String joinToString(@NotNull MatchPriority priority, @NotNull String separator, @NotNull String prefix, @NotNull String postfix, @NotNull Function1<? super String, String> transform) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        List stringList = new ArrayList();
        for (Tag tag : priority.getTagList()) {
            if (WhenMappings.$EnumSwitchMapping$0[tag.ordinal()] == 1) {
                for (String string : this.getPrivates()) {
                    if (!(!StringsKt.isBlank((CharSequence)string))) continue;
                    ((Collection)stringList).add(transform.invoke((Object)string));
                }
                continue;
            }
            if (!(!StringsKt.isBlank((CharSequence)this.get(tag)))) continue;
            ((Collection)stringList).add(transform.invoke((Object)this.get(tag)));
        }
        return CollectionsKt.joinToString$default((Iterable)stringList, (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix, (int)0, null, null, (int)56, null);
    }

    public static /* synthetic */ String joinToString$default(Lang lang, MatchPriority matchPriority, String string, String string2, String string3, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            matchPriority = MatchPriority.DEFAULT;
        }
        if ((n & 2) != 0) {
            string = "_";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        if ((n & 0x10) != 0) {
            function1 = Lang::joinToString$lambda$1;
        }
        return lang.joinToString(matchPriority, string, string2, string3, (Function1<? super String, String>)function1);
    }

    @NotNull
    public final String get(@NotNull Tag tag) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        BaseLang baseLang = this.getBaseLang();
        switch (WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
            case 2: {
                return baseLang.getLang();
            }
            case 3: {
                return baseLang.getRegion();
            }
            case 4: {
                return baseLang.getDialect();
            }
            case 5: {
                return baseLang.getScript();
            }
            case 1: {
                throw new IllegalArgumentException("");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final String[] getPrivates() {
        return this.getBaseLang().getPrivates();
    }

    @NotNull
    public final Map<Tag, String> toMutableMap() {
        Pair[] objectArray = new Pair[]{TuplesKt.to((Object)((Object)Tag.LANGUAGE), (Object)this.get(Tag.LANGUAGE)), TuplesKt.to((Object)((Object)Tag.DIALECT), (Object)this.get(Tag.DIALECT)), TuplesKt.to((Object)((Object)Tag.SCRIPT), (Object)this.get(Tag.SCRIPT)), TuplesKt.to((Object)((Object)Tag.REGION), (Object)this.get(Tag.REGION))};
        Map result = MapsKt.mutableMapOf((Pair[])objectArray);
        for (String string : this.getPrivates()) {
            Map map = result;
            Pair pair = TuplesKt.to((Object)((Object)Tag.PRIVATE), (Object)string);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return result;
    }

    @NotNull
    public final Locale toLocale() {
        Locale locale = new Locale.Builder().setLanguage(this.get(Tag.LANGUAGE)).setVariant(this.get(Tag.DIALECT)).setScript(this.get(Tag.SCRIPT)).setRegion(this.get(Tag.REGION)).build();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"build(...)");
        return locale;
    }

    private static final String joinToString$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    static {
        Object[] objectArray = new BaseLang[]{new BaseLang(null, null, null, null, null, 31, null)};
        baseLangs = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/github/createduser/lang_string/Lang$Companion;", "", "<init>", "()V", "baseLangs", "", "Lio/github/createduser/lang_string/BaseLang;", "LanguageString"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tag.values().length];
            try {
                nArray[Tag.PRIVATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.LANGUAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.REGION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.DIALECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tag.SCRIPT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

