/*
 * Decompiled with CFR 0.152.
 */
package br.com.devblack.logging.bitlogger;

import br.com.devblack.logging.bitlogger.LogContext;
import br.com.devblack.logging.configuration.Configuration;
import br.com.devblack.logging.record.LogBitRecord;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractEngineBitLogger {
    private static final Map<Level, String> mapLevels = new HashMap<Level, String>();
    private static Configuration configuration = null;
    private static final LogContext logContext = new LogContext();

    AbstractEngineBitLogger(Configuration value) {
        if (Objects.isNull(value)) {
            throw new IllegalArgumentException("Configuration value must not be null");
        }
        configuration = value;
        logContext.clear();
        logContext.setConfigurationContext(configuration);
    }

    protected static LogBitRecord log(Level level, String logCode, String message, Object payload, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, logCode);
        LogBitRecord logBitRecord = AbstractEngineBitLogger.createObject(level, logCode, message, payload, throwable);
        logRecord.setLoggerName(logCode);
        logRecord.setThreadID(Integer.parseInt(String.valueOf(Thread.currentThread().getId())));
        logRecord.setInstant(Instant.now());
        logRecord.setMessage(logBitRecord.json());
        if (configuration.isThrowable()) {
            logRecord.setThrown(throwable);
        }
        Logger.getLogger(logCode).log(logRecord);
        logContext.clearDurationTime();
        return logBitRecord;
    }

    private static LogBitRecord createObject(Level level, String logCode, String message, Object payload, Throwable throwable) {
        return LogBitRecord.init().setLogCode(logCode).setCorrelationId(AbstractEngineBitLogger.getCorrelationId()).setTransationId(AbstractEngineBitLogger.getTransactionId()).setMessage(message).setSeverity(mapLevels.get(level)).setThreadId(String.valueOf(Thread.currentThread().getId())).setPayload(payload).setThrowable(throwable).setHost(configuration.getHostAddress()).setTimeExecution(logContext.getExecutionDuration()).setCurrent(ZonedDateTime.now()).setStart(logContext.isFinish() ? logContext.getStart() : null).setFinish(logContext.getFinishDateTime()).build();
    }

    void startTimer() {
        logContext.startTimer();
    }

    void stopTimer() {
        logContext.stopTimer();
    }

    public void setCorrelationId(String correlationId) {
        logContext.setCorrelationId(correlationId);
    }

    public void setTransactionId(String transactionId) {
        logContext.setTransactionId(transactionId);
    }

    public static String getCorrelationId() {
        String correlationId = logContext.getCorrelationId();
        if (Objects.isNull(correlationId) && configuration.isCorrelationRandom()) {
            return UUID.randomUUID().toString();
        }
        return correlationId;
    }

    public static String getTransactionId() {
        String transactionId = logContext.getTransactionId();
        if (Objects.isNull(transactionId) && configuration.isTransactionRandom()) {
            return UUID.randomUUID().toString();
        }
        return transactionId;
    }

    public abstract LogBitRecord info(String var1, String var2, Object var3);

    public abstract LogBitRecord warning(String var1, String var2, Object var3, Throwable var4);

    public abstract LogBitRecord warning(String var1, String var2, Object var3);

    public abstract LogBitRecord error(String var1, String var2, Object var3, Throwable var4);

    public abstract LogBitRecord debug(String var1, String var2, Object var3, Throwable var4);

    public abstract LogBitRecord debug(String var1, String var2, Object var3);

    public abstract LogBitRecord logInfoStart(String var1, String var2, Object var3);

    public abstract LogBitRecord logWarningStart(String var1, String var2, Object var3);

    public abstract LogBitRecord logWarningStart(String var1, String var2, Object var3, Throwable var4);

    public abstract LogBitRecord logInfoFinish(String var1, String var2, Object var3);

    public abstract LogBitRecord logWarningFinish(String var1, String var2, Object var3);

    public abstract LogBitRecord logWarningFinish(String var1, String var2, Object var3, Throwable var4);

    static {
        mapLevels.put(Level.SEVERE, "ERROR");
        mapLevels.put(Level.ALL, "DEBUG");
        mapLevels.put(Level.INFO, "INFO");
        mapLevels.put(Level.WARNING, "WARNING");
    }
}

