/*
 * Decompiled with CFR 0.152.
 */
package br.com.devblack.logging.bitlogger;

import br.com.devblack.logging.configuration.Configuration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.MDC;

public class LogContext {
    public static final String APPLICATION_NAME = "applicationName";
    public static final String HOST_ADDRESS = "hostAddress";
    public static final String ORGANIZATION_NAME = "organizationName";
    public static final String CORRELATION_ID = "correlationId";
    public static final String TRANSACTION_ID = "transactionId";
    private ZonedDateTime startDateTime = null;
    private long startNano = 0L;
    private ZonedDateTime finishDateTime = null;
    private long finishNano = 0L;
    private String correlationId = null;
    private String transactionId = null;

    public long getExecutionDuration() {
        return this.finishNano - this.startNano;
    }

    public boolean isFinish() {
        return Objects.nonNull(this.finishDateTime);
    }

    public ZonedDateTime getStart() {
        return this.startDateTime;
    }

    public ZonedDateTime getFinishDateTime() {
        return this.finishDateTime;
    }

    protected void startTimer() {
        this.startDateTime = ZonedDateTime.now();
        this.startNano = this.startDateTime.getNano();
    }

    protected void stopTimer() {
        this.finishDateTime = ZonedDateTime.now();
        this.finishNano = this.finishDateTime.getNano();
    }

    public void clearDurationTime() {
        if (Objects.nonNull(this.finishDateTime)) {
            this.finishDateTime = null;
            this.finishNano = 0L;
            this.startDateTime = null;
            this.startNano = 0L;
        }
    }

    public void clear() {
        this.correlationId = null;
        this.transactionId = null;
        this.finishDateTime = null;
        this.finishNano = 0L;
        this.startDateTime = null;
        this.startNano = 0L;
    }

    public String getCorrelationId() {
        return Optional.ofNullable(MDC.get((String)CORRELATION_ID)).orElse(this.correlationId);
    }

    public String getTransactionId() {
        return Optional.ofNullable(MDC.get((String)TRANSACTION_ID)).orElse(this.transactionId);
    }

    public void setCorrelationId(String value) {
        MDC.put((String)CORRELATION_ID, (String)value);
        this.correlationId = value;
    }

    public void setTransactionId(String value) {
        MDC.put((String)TRANSACTION_ID, (String)value);
        this.transactionId = value;
    }

    public void setConfigurationContext(Configuration value) {
        MDC.put((String)APPLICATION_NAME, (String)value.getApplicationName());
        MDC.put((String)ORGANIZATION_NAME, (String)value.getOrganizationName());
        MDC.put((String)HOST_ADDRESS, (String)value.getHostAddress());
    }
}

