/*
 * Decompiled with CFR 0.152.
 */
package br.com.devblack.logging.configuration;

import java.net.InetAddress;

public class Configuration {
    private static final String EMPTY = "";
    private final String applicationName;
    private final String organizationName;
    private final String hostAddress;
    private boolean isThrowable;
    private boolean isCorrelationRandom = false;
    private boolean isTransactionRandom = false;

    public Configuration(String applicationName, String organizationName, String hostAddress, boolean isThrowable) {
        this.applicationName = applicationName;
        this.organizationName = organizationName;
        this.hostAddress = hostAddress;
        this.isThrowable = isThrowable;
    }

    public Configuration(String applicationName, String organizationName, boolean isThrowable) {
        this.applicationName = applicationName;
        this.organizationName = organizationName;
        this.isThrowable = isThrowable;
        this.hostAddress = this.getHost();
    }

    private String getHost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return EMPTY;
        }
    }

    public boolean isThrowable() {
        return this.isThrowable;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void enableRandomCorrelation() {
        this.isCorrelationRandom = true;
    }

    public void disableRandomCorrelation() {
        this.isCorrelationRandom = false;
    }

    public void enableRandomTransaction() {
        this.isTransactionRandom = true;
    }

    public void disableRandomTransaction() {
        this.isTransactionRandom = false;
    }

    public void enableThrowable() {
        this.isThrowable = true;
    }

    public void disableThrowable() {
        this.isThrowable = false;
    }

    public boolean isCorrelationRandom() {
        return this.isCorrelationRandom;
    }

    public boolean isTransactionRandom() {
        return this.isTransactionRandom;
    }
}

