/*
 * Decompiled with CFR 0.152.
 */
package br.com.devblack.logging.record;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LogBitRecord
implements Serializable {
    private String correlationId = null;
    private String transactionId = null;
    private String threadId = null;
    private String logCode = null;
    private String message = null;
    private Object payload = null;
    private Throwable throwable = null;
    private ZonedDateTime start = null;
    private ZonedDateTime finish = null;
    private ZonedDateTime current = null;
    private long timeExecution = 0L;
    private String severity = null;
    private String host = null;

    private LogBitRecord() {
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getLogCode() {
        return this.logCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public Object getPayload() {
        return this.payload;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getHost() {
        return this.host;
    }

    public String getStart() {
        if (Objects.nonNull(this.start)) {
            return String.valueOf(this.start.toLocalDateTime());
        }
        return null;
    }

    public String getFinish() {
        if (Objects.nonNull(this.finish)) {
            return String.valueOf(this.finish.toLocalDateTime());
        }
        return null;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getCurrent() {
        if (Objects.nonNull(this.current)) {
            return String.valueOf(this.current.toLocalDateTime());
        }
        return null;
    }

    public String getTimeExecution() {
        if (this.timeExecution <= 0L) {
            return null;
        }
        return TimeUnit.MILLISECONDS.convert(this.timeExecution, TimeUnit.NANOSECONDS) + "ms";
    }

    public static LogBitRecord init() {
        return new LogBitRecord();
    }

    public LogBitRecord setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public LogBitRecord setTransationId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public LogBitRecord setHost(String host) {
        this.host = host;
        return this;
    }

    public LogBitRecord setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    public LogBitRecord setLogCode(String logCode) {
        this.logCode = logCode;
        return this;
    }

    public LogBitRecord setMessage(String message) {
        this.message = message;
        return this;
    }

    public LogBitRecord setPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public LogBitRecord setCurrent(ZonedDateTime current) {
        this.current = current;
        return this;
    }

    public LogBitRecord setTimeExecution(long timeExecution) {
        this.timeExecution = timeExecution;
        return this;
    }

    public LogBitRecord setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public LogBitRecord setStart(ZonedDateTime start) {
        this.start = start;
        return this;
    }

    public LogBitRecord setFinish(ZonedDateTime finish) {
        this.finish = finish;
        return this;
    }

    public LogBitRecord setSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    public LogBitRecord build() {
        return this;
    }

    public String json() {
        try {
            return new JsonMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

