/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql;

import io.gitbub.devlibx.easy.helper.metrics.IMetrics;
import io.github.devlibx.easy.database.exception.DatabaseExceptions;
import io.github.devlibx.easy.database.mysql.IMysqlHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlHelper
implements IMysqlHelper {
    private static final Logger log = LoggerFactory.getLogger(MySqlHelper.class);
    private final DataSource dataSource;
    private final IMetrics metrics;
    private final Set<String> metricsRegistered;

    @Inject
    public MySqlHelper(DataSource dataSource, IMetrics metrics) {
        this.dataSource = dataSource;
        this.metrics = metrics;
        this.metricsRegistered = new HashSet<String>();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(String metricsName, String sql, IMysqlHelper.IStatementBuilder statementBuilder) {
        this.safeRegisterMetric(metricsName);
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statementBuilder.prepare(statement);
                    bl = (Boolean)this.metrics.time(metricsName, statement::execute, new String[0]);
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                e.printStackTrace();
            }
            throw new DatabaseExceptions.ExecuteException(sql, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean executeUpdate(String metricsName, String sql, IMysqlHelper.IStatementBuilder statementBuilder) {
        this.safeRegisterMetric(metricsName);
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statementBuilder.prepare(statement);
                    bl = (Boolean)this.metrics.time(metricsName, () -> statement.executeUpdate() > 0, new String[0]);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw new DatabaseExceptions.ExecuteException(sql, (Throwable)e);
        }
    }

    @Override
    public Long persist(String metricsName, String sql, IMysqlHelper.IStatementBuilder statementBuilder) {
        this.safeRegisterMetric(metricsName);
        return (Long)this.persist(metricsName, sql, statementBuilder, resultSet -> {
            try {
                return Long.valueOf(resultSet.getLong(1));
            }
            catch (SQLException e) {
                return new DatabaseExceptions.PersistException(sql, (Throwable)e);
            }
        });
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T persist(String metricsName, String sql, IMysqlHelper.IStatementBuilder statementBuilder, Function<ResultSet, T> keyFunction) {
        this.safeRegisterMetric(metricsName);
        try (Connection connection = this.dataSource.getConnection();){
            T t;
            block25: {
                ResultSet generatedKeys;
                PreparedStatement statement;
                block22: {
                    ResultSet resultSet;
                    block24: {
                        block23: {
                            statement = connection.prepareStatement(sql, 1);
                            statementBuilder.prepare(statement);
                            this.metrics.time(metricsName, statement::execute, new String[0]);
                            generatedKeys = statement.getGeneratedKeys();
                            if (!generatedKeys.next()) break block22;
                            resultSet = keyFunction.apply(generatedKeys);
                            if (generatedKeys == null) break block23;
                            generatedKeys.close();
                        }
                        if (statement == null) break block24;
                        statement.close();
                    }
                    return (T)resultSet;
                }
                try {
                    block26: {
                        if (generatedKeys != null) {
                            generatedKeys.close();
                        }
                        break block26;
                        {
                            catch (Throwable throwable) {
                                if (generatedKeys != null) {
                                    try {
                                        generatedKeys.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    t = null;
                    if (statement == null) break block25;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return t;
        }
        catch (SQLException e) {
            throw new DatabaseExceptions.PersistException(sql, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Optional<T> findOne(String metricsName, String sql, IMysqlHelper.IStatementBuilder statementBuilder, IMysqlHelper.IRowMapper<T> rowMapper, Class<T> cls) {
        this.safeRegisterMetric(metricsName);
        try (Connection connection = this.dataSource.getConnection();){
            Optional optional;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statementBuilder.prepare(statement);
                    optional = (Optional)this.metrics.time(metricsName, () -> {
                        try (ResultSet rs = statement.executeQuery();){
                            Optional optional = rs.next() ? Optional.of(rowMapper.map(rs)) : Optional.empty();
                            return optional;
                        }
                    }, new String[0]);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return optional;
        }
        catch (Exception e) {
            throw new DatabaseExceptions.FindException(sql, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> Optional<List<T>> findAll(String metricsName, String sql, IMysqlHelper.IStatementBuilder statementBuilder, IMysqlHelper.IRowMapper<T> rowMapper, Class<T> cls) {
        this.safeRegisterMetric(metricsName);
        try (Connection connection = this.dataSource.getConnection();){
            Optional optional;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statementBuilder.prepare(statement);
                    optional = (Optional)this.metrics.time(metricsName, () -> {
                        try (ResultSet rs = statement.executeQuery();){
                            Optional optional = rowMapper.rows(rs);
                            return optional;
                        }
                    }, new String[0]);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return optional;
        }
        catch (Exception e) {
            throw new DatabaseExceptions.FindException(sql, (Throwable)e);
        }
    }

    private void safeRegisterMetric(String name) {
        if (this.metricsRegistered.contains(name)) {
            return;
        }
        this.metrics.registerTimer(name, name + " Help", new String[0]);
        this.metricsRegistered.add(name);
    }
}

