/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.zaxxer.hikari.HikariDataSource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MySqlConfig {
    private boolean isAutoCommit;
    private String driverClassName;
    private String jdbcUrl;
    private String username;
    private String password;
    private long idleTimeout;
    private int maxPoolSize = 10;
    private long leakDetectionThreshold;
    private boolean useLocalSessionState;
    private boolean useUsageAdvisor;
    private boolean showSql;

    public HikariDataSource buildHikariDataSource() {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setAutoCommit(true);
        dataSource.setJdbcUrl(this.jdbcUrl);
        dataSource.setDriverClassName(this.driverClassName);
        dataSource.setUsername(this.username);
        dataSource.setPassword(this.password);
        dataSource.setIdleTimeout(this.idleTimeout);
        dataSource.setMaximumPoolSize(this.maxPoolSize);
        dataSource.setLeakDetectionThreshold(this.leakDetectionThreshold);
        dataSource.addDataSourceProperty("useLocalSessionState", (Object)this.useLocalSessionState);
        dataSource.addDataSourceProperty("useUsageAdvisor", (Object)this.useUsageAdvisor);
        if (this.showSql) {
            dataSource.addDataSourceProperty("logger", (Object)"Slf4JLogger");
            dataSource.addDataSourceProperty("profilerEventHandler", (Object)"io.github.devlibx.easy.database.mysql.debug.DoNotUseProfilerEventHandler");
            dataSource.addDataSourceProperty("profileSQL", (Object)true);
        }
        return dataSource;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    public boolean isUseLocalSessionState() {
        return this.useLocalSessionState;
    }

    public boolean isUseUsageAdvisor() {
        return this.useUsageAdvisor;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setLeakDetectionThreshold(long leakDetectionThreshold) {
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    public void setUseLocalSessionState(boolean useLocalSessionState) {
        this.useLocalSessionState = useLocalSessionState;
    }

    public void setUseUsageAdvisor(boolean useUsageAdvisor) {
        this.useUsageAdvisor = useUsageAdvisor;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MySqlConfig)) {
            return false;
        }
        MySqlConfig other = (MySqlConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoCommit() != other.isAutoCommit()) {
            return false;
        }
        if (this.getIdleTimeout() != other.getIdleTimeout()) {
            return false;
        }
        if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
            return false;
        }
        if (this.getLeakDetectionThreshold() != other.getLeakDetectionThreshold()) {
            return false;
        }
        if (this.isUseLocalSessionState() != other.isUseLocalSessionState()) {
            return false;
        }
        if (this.isUseUsageAdvisor() != other.isUseUsageAdvisor()) {
            return false;
        }
        if (this.isShowSql() != other.isShowSql()) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MySqlConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoCommit() ? 79 : 97);
        long $idleTimeout = this.getIdleTimeout();
        result = result * 59 + (int)($idleTimeout >>> 32 ^ $idleTimeout);
        result = result * 59 + this.getMaxPoolSize();
        long $leakDetectionThreshold = this.getLeakDetectionThreshold();
        result = result * 59 + (int)($leakDetectionThreshold >>> 32 ^ $leakDetectionThreshold);
        result = result * 59 + (this.isUseLocalSessionState() ? 79 : 97);
        result = result * 59 + (this.isUseUsageAdvisor() ? 79 : 97);
        result = result * 59 + (this.isShowSql() ? 79 : 97);
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "MySqlConfig(isAutoCommit=" + this.isAutoCommit() + ", driverClassName=" + this.getDriverClassName() + ", jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", idleTimeout=" + this.getIdleTimeout() + ", maxPoolSize=" + this.getMaxPoolSize() + ", leakDetectionThreshold=" + this.getLeakDetectionThreshold() + ", useLocalSessionState=" + this.isUseLocalSessionState() + ", useUsageAdvisor=" + this.isUseUsageAdvisor() + ", showSql=" + this.isShowSql() + ")";
    }
}

