/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql.lock;

import com.zaxxer.hikari.HikariDataSource;
import io.gitbub.devlibx.easy.helper.Safe;
import io.github.devlibx.easy.lock.IDistributedLock;
import io.github.devlibx.easy.lock.IDistributedLockService;
import io.github.devlibx.easy.lock.config.LockConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDistributedLockV2
implements IDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(MySqlDistributedLockV2.class);
    private static final ThreadLockStore lockStore = new ThreadLockStore();
    private final DataSource dataSource;
    private final String lockTableName;
    private LockConfig lockConfig;

    @Inject
    public MySqlDistributedLockV2(@Named(value="lock_table_data_source") DataSource dataSource, @Named(value="lock_table_name") String lockTableName) {
        this.dataSource = dataSource;
        this.lockTableName = lockTableName;
    }

    public void setup(LockConfig lockConfig) {
        this.lockConfig = lockConfig;
    }

    public void tearDown() {
        if (!(this.dataSource instanceof HikariDataSource)) {
            throw new RuntimeException("Could not close datasource - dataSource Class=" + this.dataSource.getClass());
        }
        Safe.safe(() -> ((HikariDataSource)((HikariDataSource)this.dataSource)).close());
    }

    public void releaseResources() {
        lockStore.reset();
    }

    public Lock achieveLock(IDistributedLock.LockRequest request) {
        InternalLock existingLock = lockStore.hasExistingRequest(request);
        if (existingLock != null) {
            return new IDistributedLockService.ExistingLockWithNoOp((Lock)existingLock);
        }
        InternalLock internalLock = new InternalLock(this.dataSource, request, this.lockTableName, this.lockConfig);
        internalLock.lock();
        lockStore.set(request, internalLock);
        return internalLock;
    }

    public void releaseLock(Lock lock, IDistributedLock.LockRequest lockRequest) {
        try {
            lock.unlock();
        }
        finally {
            if (!(lock instanceof IDistributedLockService.ExistingLockWithNoOp)) {
                if (lock instanceof InternalLock) {
                    lockStore.remove(((InternalLock)lock).getRequest());
                } else {
                    lockStore.remove(lockRequest);
                }
            }
        }
    }

    private static class ThreadLockStore {
        private static final ThreadLocal<Map<String, InternalLock>> locksInCurrentThread = new ThreadLocal();

        private ThreadLockStore() {
        }

        public InternalLock hasExistingRequest(IDistributedLock.LockRequest request) {
            Map.Entry key;
            if (locksInCurrentThread.get() == null) {
                return null;
            }
            if (locksInCurrentThread.get().size() > 10) {
                Thread.dumpStack();
                log.error("Potential leak in MySqlDistributedLockV2 class: thread local has > 10 locks. It could only happen if your call stack is > 10 and more than 10 method in call stack are taking distributed lock with different lock IDs. If this is not the case then this is a bug in MySqlDistributedLockV2 implementation.");
            }
            return (key = (Map.Entry)locksInCurrentThread.get().entrySet().stream().filter(entry -> Objects.equals(entry.getKey(), request.getUniqueLockIdForLocking())).findFirst().orElse(null)) != null ? (InternalLock)key.getValue() : null;
        }

        public void set(IDistributedLock.LockRequest request, InternalLock lock) {
            if (locksInCurrentThread.get() == null) {
                locksInCurrentThread.set(new HashMap());
            }
            Map<String, InternalLock> locks = locksInCurrentThread.get();
            locks.put(request.getUniqueLockIdForLocking(), lock);
        }

        public void remove(IDistributedLock.LockRequest lockRequest) {
            if (locksInCurrentThread.get() != null) {
                locksInCurrentThread.get().remove(lockRequest.getUniqueLockIdForLocking());
            }
        }

        public void reset() {
            if (locksInCurrentThread.get() != null) {
                locksInCurrentThread.get().clear();
            }
            locksInCurrentThread.remove();
        }
    }

    private static class InternalLock
    implements Lock {
        private static AtomicLong COUNTER = new AtomicLong();
        private final long uniqueId = COUNTER.incrementAndGet();
        private final DataSource dataSource;
        private final IDistributedLock.LockRequest request;
        private final String lockTableName;
        private final LockConfig lockConfig;
        private Connection connection;
        private PreparedStatement selectStatement;

        private InternalLock(DataSource dataSource, IDistributedLock.LockRequest request, String lockTableName, LockConfig lockConfig) {
            this.dataSource = dataSource;
            this.request = request;
            this.lockTableName = lockTableName;
            this.lockConfig = lockConfig;
        }

        private boolean tryLockWithSelect(Connection connection, String lockIdToUse) throws SQLException {
            if (this.selectStatement != null) {
                Safe.safe(() -> this.selectStatement.close());
            }
            this.selectStatement = connection.prepareStatement(String.format("SELECT * FROM %s WHERE lock_id=? FOR UPDATE", this.lockTableName));
            this.selectStatement.setString(1, lockIdToUse);
            this.selectStatement.setQueryTimeout(this.lockConfig.getTimeoutInSec());
            ResultSet rs = this.selectStatement.executeQuery();
            return rs.next();
        }

        private boolean tryInsertLock(Connection connection, String lockIdToUse) {
            try (PreparedStatement insertStatement = connection.prepareStatement(String.format("INSERT IGNORE INTO %s(lock_id) VALUES(?)", this.lockTableName));){
                log.trace("Try to inserted lock row in db: id={}", (Object)lockIdToUse);
                insertStatement.setString(1, lockIdToUse);
                insertStatement.setQueryTimeout(this.lockConfig.getTimeoutInSec());
                insertStatement.execute();
                log.trace("Lock row inserted: id={}", (Object)lockIdToUse);
            }
            catch (Throwable e) {
                log.error("Failed to insert lock for the first time", e);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lock() {
            int retryPending = 1;
            String lockIdToUse = this.request.getUniqueLockIdForLocking();
            log.debug("Try to take lock: id={}", (Object)lockIdToUse);
            do {
                try {
                    if (this.connection != null) {
                        Safe.safe(() -> {
                            this.connection.setAutoCommit(true);
                            this.connection.close();
                            this.connection = null;
                        });
                    }
                    this.connection = this.dataSource.getConnection();
                    this.connection.setAutoCommit(false);
                    boolean foundLockInDB = this.tryLockWithSelect(this.connection, lockIdToUse);
                    if (foundLockInDB) {
                        log.debug("Lock taken: id={}", (Object)lockIdToUse);
                        return;
                    }
                    log.debug("(first time lock) Try to insert lock: id={}", (Object)lockIdToUse);
                    boolean insertLock = this.tryInsertLock(this.connection, lockIdToUse);
                    if (insertLock) {
                        log.debug("Lock inserted (we acquired lock): id={}", (Object)lockIdToUse);
                        return;
                    }
                }
                catch (Exception e) {
                    log.error("Error in getting lock - we will retry: id={}, error={}", (Object)lockIdToUse, (Object)e.getMessage());
                    Safe.safe(() -> {
                        this.selectStatement.close();
                        this.selectStatement = null;
                    });
                    Safe.safe(() -> {
                        this.connection.rollback();
                        this.connection.setAutoCommit(true);
                        this.connection.close();
                        this.connection = null;
                    });
                    Safe.safe(() -> {
                        if (this.connection != null) {
                            this.connection.close();
                            this.connection = null;
                        }
                    });
                }
                finally {
                    --retryPending;
                }
                log.warn("Lock not taken: id={}, retry_count={}", (Object)lockIdToUse, (Object)retryPending);
            } while (retryPending >= 0);
            throw new RuntimeException(String.format("lock cannot be taken: name=%s, id=%s", this.request.getName(), this.request.getLockId()));
        }

        @Override
        public void unlock() {
            log.debug("Try to unlock lock: id={}", (Object)this.request.getUniqueLockIdForLocking());
            try {
                Safe.safe(() -> {
                    this.selectStatement.close();
                    this.selectStatement = null;
                });
                this.connection.commit();
                this.connection.setAutoCommit(true);
                this.connection.close();
                this.connection = null;
                log.debug("Unlock done: id={}", (Object)this.request.getUniqueLockIdForLocking());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("lock cannot be released: name=%s, id=%s", this.request.getName(), this.request.getLockId()), e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean tryLock() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public Condition newCondition() {
            throw new RuntimeException("Not implemented");
        }

        public String toString() {
            if (log.isTraceEnabled()) {
                return super.toString();
            }
            return String.format("UniqueId=%d, LockId=%s", this.uniqueId, this.request.getUniqueLockIdForLocking());
        }

        public long getUniqueId() {
            return this.uniqueId;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public IDistributedLock.LockRequest getRequest() {
            return this.request;
        }

        public String getLockTableName() {
            return this.lockTableName;
        }

        public LockConfig getLockConfig() {
            return this.lockConfig;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public PreparedStatement getSelectStatement() {
            return this.selectStatement;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public void setSelectStatement(PreparedStatement selectStatement) {
            this.selectStatement = selectStatement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InternalLock)) {
                return false;
            }
            InternalLock other = (InternalLock)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUniqueId() != other.getUniqueId()) {
                return false;
            }
            DataSource this$dataSource = this.getDataSource();
            DataSource other$dataSource = other.getDataSource();
            if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
                return false;
            }
            IDistributedLock.LockRequest this$request = this.getRequest();
            IDistributedLock.LockRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            String this$lockTableName = this.getLockTableName();
            String other$lockTableName = other.getLockTableName();
            if (this$lockTableName == null ? other$lockTableName != null : !this$lockTableName.equals(other$lockTableName)) {
                return false;
            }
            LockConfig this$lockConfig = this.getLockConfig();
            LockConfig other$lockConfig = other.getLockConfig();
            if (this$lockConfig == null ? other$lockConfig != null : !this$lockConfig.equals(other$lockConfig)) {
                return false;
            }
            Connection this$connection = this.getConnection();
            Connection other$connection = other.getConnection();
            if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
                return false;
            }
            PreparedStatement this$selectStatement = this.getSelectStatement();
            PreparedStatement other$selectStatement = other.getSelectStatement();
            return !(this$selectStatement == null ? other$selectStatement != null : !this$selectStatement.equals(other$selectStatement));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InternalLock;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $uniqueId = this.getUniqueId();
            result = result * 59 + (int)($uniqueId >>> 32 ^ $uniqueId);
            DataSource $dataSource = this.getDataSource();
            result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
            IDistributedLock.LockRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            String $lockTableName = this.getLockTableName();
            result = result * 59 + ($lockTableName == null ? 43 : $lockTableName.hashCode());
            LockConfig $lockConfig = this.getLockConfig();
            result = result * 59 + ($lockConfig == null ? 43 : $lockConfig.hashCode());
            Connection $connection = this.getConnection();
            result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
            PreparedStatement $selectStatement = this.getSelectStatement();
            result = result * 59 + ($selectStatement == null ? 43 : $selectStatement.hashCode());
            return result;
        }
    }
}

