/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.database.mysql.healthcheck;

import io.gitbub.devlibx.easy.helper.healthcheck.IHealthCheckProvider;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.easy.database.mysql.DataSourceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class MySqlHealthCheckProvider
implements IHealthCheckProvider {
    private static final Logger log = LoggerFactory.getLogger(MySqlHealthCheckProvider.class);
    private final DataSourceFactory dataSourceFactory;

    @Inject
    public MySqlHealthCheckProvider(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public IHealthCheckProvider.Result check() {
        StringBuilder sb = new StringBuilder();
        StringObjectMap message = new StringObjectMap();
        AtomicBoolean errorFound = new AtomicBoolean(false);
        try {
            this.dataSourceFactory.getDataSourceMap().forEach((name, _dataSource) -> {
                DataSource dataSource = _dataSource;
                if (_dataSource instanceof TransactionAwareDataSourceProxy) {
                    dataSource = ((TransactionAwareDataSourceProxy)_dataSource).getTargetDataSource();
                }
                if (dataSource == null) {
                    message.put(name, (Object)("Failed to get datasource for " + name));
                    errorFound.set(true);
                    return;
                }
                try (Connection connection = dataSource.getConnection();
                     PreparedStatement statement = connection.prepareStatement("SELECT 1");){
                    statement.execute();
                    message.put(name, (Object)"OK");
                    sb.append((String)name).append("[").append("OK").append("], ");
                }
                catch (Exception e) {
                    log.error("Failed to connect to {} DB", name, (Object)e);
                    message.put(name, (Object)("Failed to connect to " + name + " DB: " + e.getMessage()));
                    errorFound.set(true);
                    sb.append((String)name).append("[").append(e.getMessage()).append("], ");
                }
            });
        }
        catch (Exception e) {
            return IHealthCheckProvider.Result.builder().healthy(false).details((Map)message).error((Throwable)e).message("Failed to check health of DB - " + e.getMessage()).build();
        }
        if (errorFound.get()) {
            return IHealthCheckProvider.Result.builder().healthy(false).details((Map)message).message(sb.toString() + " DB(s) failed").build();
        }
        return IHealthCheckProvider.Result.builder().healthy(true).details((Map)message).message(sb.toString() + " DB(s) Ok").build();
    }
}

