/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private final ObjectMapper objectMapper;

    public JsonUtil() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.objectMapper.registerModule((Module)new JodaModule());
    }

    public JsonUtil(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T readObject(String str, Class<T> cls) {
        try {
            if (str == null) {
                return null;
            }
            if (cls.isAssignableFrom(String.class)) {
                return (T)str;
            }
            return (T)this.objectMapper.readValue(str, cls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T readObject(String str, JavaType cls) {
        try {
            if (str == null) {
                return null;
            }
            if (cls.getClass().isAssignableFrom(String.class)) {
                return (T)str;
            }
            return (T)this.objectMapper.readValue(str, cls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> readList(String str, Class<T> cls) {
        try {
            return (List)this.objectMapper.readValue(str, (JavaType)TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, cls));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert string to List<cls>");
        }
    }

    public Map<String, Object> convertAsMap(String str) {
        return this.readObject(str, Map.class);
    }

    public StringObjectMap convertAsStringObjectMap(String str) {
        return this.readObject(str, StringObjectMap.class);
    }

    public StringObjectMap convertAsStringObjectMap(byte[] bytes) {
        String str = new String(bytes);
        return this.readObject(str, StringObjectMap.class);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

