/*
 * Decompiled with CFR 0.152.
 */
package io.gitbub.devlibx.easy.helper.string;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gitbub.devlibx.easy.helper.json.JsonUtil;
import java.util.UUID;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class StringHelper {
    private final JsonUtil jsonUtil;

    public StringHelper() {
        this.jsonUtil = new JsonUtil();
    }

    @Inject
    public StringHelper(JsonUtil jsonUtil) {
        this.jsonUtil = jsonUtil;
    }

    public String stringify(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj.toString();
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof DateTime) {
            return "" + ((DateTime)obj).getMillis();
        }
        if (obj instanceof UUID) {
            return obj.toString();
        }
        try {
            return this.jsonUtil.getObjectMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

