/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Server;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Config {
    private Map<String, Server> servers;
    private Map<String, Api> apis;

    public void addServer(Server server) {
        if (this.servers == null) {
            this.servers = new HashMap<String, Server>();
        }
        this.servers.put(server.getName(), server);
    }

    public void addApi(Api api) {
        if (this.apis == null) {
            this.apis = new HashMap<String, Api>();
        }
        this.apis.put(api.getName(), api);
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public Map<String, Server> getServers() {
        return this.servers;
    }

    public Map<String, Api> getApis() {
        return this.apis;
    }

    public void setServers(Map<String, Server> servers) {
        this.servers = servers;
    }

    public void setApis(Map<String, Api> apis) {
        this.apis = apis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Server> this$servers = this.getServers();
        Map<String, Server> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        Map<String, Api> this$apis = this.getApis();
        Map<String, Api> other$apis = other.getApis();
        return !(this$apis == null ? other$apis != null : !((Object)this$apis).equals(other$apis));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Server> $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        Map<String, Api> $apis = this.getApis();
        result = result * 59 + ($apis == null ? 43 : ((Object)$apis).hashCode());
        return result;
    }

    public String toString() {
        return "Config(servers=" + this.getServers() + ", apis=" + this.getApis() + ")";
    }

    public Config() {
    }

    public Config(Map<String, Server> servers, Map<String, Api> apis) {
        this.servers = servers;
        this.apis = apis;
    }

    public static class ConfigBuilder {
        private Map<String, Server> servers;
        private Map<String, Api> apis;

        ConfigBuilder() {
        }

        public ConfigBuilder servers(Map<String, Server> servers) {
            this.servers = servers;
            return this;
        }

        public ConfigBuilder apis(Map<String, Api> apis) {
            this.apis = apis;
            return this;
        }

        public Config build() {
            return new Config(this.servers, this.apis);
        }

        public String toString() {
            return "Config.ConfigBuilder(servers=" + this.servers + ", apis=" + this.apis + ")";
        }
    }
}

