/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.easy.http.util.Call;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestObject {
    private String server;
    private String api;
    private String method;
    private Map<String, Object> headers;
    private Map<String, Object> pathParam;
    private MultivaluedMap<String, Object> queryParam;
    private byte[] body;
    private Call.IResponseBuilderFunc<?> responseBuilder;

    public void preProcessHeaders(StringObjectMap apiHeaders) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        if (!this.headers.containsKey("Content-Type") && !this.headers.containsKey("content-type")) {
            this.headers.put("Content-Type", "application/json");
        }
        if (apiHeaders != null) {
            this.headers.putAll((Map<String, Object>)apiHeaders);
        }
    }

    public static RequestObjectBuilder builder() {
        return new RequestObjectBuilder();
    }

    public String getServer() {
        return this.server;
    }

    public String getApi() {
        return this.api;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getPathParam() {
        return this.pathParam;
    }

    public MultivaluedMap<String, Object> getQueryParam() {
        return this.queryParam;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Call.IResponseBuilderFunc<?> getResponseBuilder() {
        return this.responseBuilder;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setPathParam(Map<String, Object> pathParam) {
        this.pathParam = pathParam;
    }

    public void setQueryParam(MultivaluedMap<String, Object> queryParam) {
        this.queryParam = queryParam;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setResponseBuilder(Call.IResponseBuilderFunc<?> responseBuilder) {
        this.responseBuilder = responseBuilder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestObject)) {
            return false;
        }
        RequestObject other = (RequestObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, Object> this$headers = this.getHeaders();
        Map<String, Object> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Map<String, Object> this$pathParam = this.getPathParam();
        Map<String, Object> other$pathParam = other.getPathParam();
        if (this$pathParam == null ? other$pathParam != null : !((Object)this$pathParam).equals(other$pathParam)) {
            return false;
        }
        MultivaluedMap<String, Object> this$queryParam = this.getQueryParam();
        MultivaluedMap<String, Object> other$queryParam = other.getQueryParam();
        if (this$queryParam == null ? other$queryParam != null : !this$queryParam.equals(other$queryParam)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        Call.IResponseBuilderFunc<?> this$responseBuilder = this.getResponseBuilder();
        Call.IResponseBuilderFunc<?> other$responseBuilder = other.getResponseBuilder();
        return !(this$responseBuilder == null ? other$responseBuilder != null : !this$responseBuilder.equals(other$responseBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, Object> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Map<String, Object> $pathParam = this.getPathParam();
        result = result * 59 + ($pathParam == null ? 43 : ((Object)$pathParam).hashCode());
        MultivaluedMap<String, Object> $queryParam = this.getQueryParam();
        result = result * 59 + ($queryParam == null ? 43 : $queryParam.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        Call.IResponseBuilderFunc<?> $responseBuilder = this.getResponseBuilder();
        result = result * 59 + ($responseBuilder == null ? 43 : $responseBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "RequestObject(server=" + this.getServer() + ", api=" + this.getApi() + ", method=" + this.getMethod() + ", headers=" + String.valueOf(this.getHeaders()) + ", pathParam=" + String.valueOf(this.getPathParam()) + ", queryParam=" + String.valueOf(this.getQueryParam()) + ", body=" + Arrays.toString(this.getBody()) + ", responseBuilder=" + String.valueOf(this.getResponseBuilder()) + ")";
    }

    public RequestObject() {
    }

    public RequestObject(String server, String api, String method, Map<String, Object> headers, Map<String, Object> pathParam, MultivaluedMap<String, Object> queryParam, byte[] body, Call.IResponseBuilderFunc<?> responseBuilder) {
        this.server = server;
        this.api = api;
        this.method = method;
        this.headers = headers;
        this.pathParam = pathParam;
        this.queryParam = queryParam;
        this.body = body;
        this.responseBuilder = responseBuilder;
    }

    public static class RequestObjectBuilder {
        private String server;
        private String api;
        private String method;
        private Map<String, Object> headers;
        private Map<String, Object> pathParam;
        private MultivaluedMap<String, Object> queryParam;
        private byte[] body;
        private Call.IResponseBuilderFunc<?> responseBuilder;

        RequestObjectBuilder() {
        }

        public RequestObjectBuilder server(String server) {
            this.server = server;
            return this;
        }

        public RequestObjectBuilder api(String api) {
            this.api = api;
            return this;
        }

        public RequestObjectBuilder method(String method) {
            this.method = method;
            return this;
        }

        public RequestObjectBuilder headers(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        public RequestObjectBuilder pathParam(Map<String, Object> pathParam) {
            this.pathParam = pathParam;
            return this;
        }

        public RequestObjectBuilder queryParam(MultivaluedMap<String, Object> queryParam) {
            this.queryParam = queryParam;
            return this;
        }

        public RequestObjectBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public RequestObjectBuilder responseBuilder(Call.IResponseBuilderFunc<?> responseBuilder) {
            this.responseBuilder = responseBuilder;
            return this;
        }

        public RequestObject build() {
            return new RequestObject(this.server, this.api, this.method, this.headers, this.pathParam, this.queryParam, this.body, this.responseBuilder);
        }

        public String toString() {
            return "RequestObject.RequestObjectBuilder(server=" + this.server + ", api=" + this.api + ", method=" + this.method + ", headers=" + String.valueOf(this.headers) + ", pathParam=" + String.valueOf(this.pathParam) + ", queryParam=" + String.valueOf(this.queryParam) + ", body=" + Arrays.toString(this.body) + ", responseBuilder=" + String.valueOf(this.responseBuilder) + ")";
        }
    }
}

