/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.devlibx.easy.http.ResponseObject;
import io.github.devlibx.easy.resilience.exception.CircuitOpenException;
import io.github.devlibx.easy.resilience.exception.OverflowException;
import io.github.devlibx.easy.resilience.exception.RequestTimeoutException;
import io.github.devlibx.easy.resilience.exception.ResilienceException;
import io.netty.handler.timeout.ReadTimeoutException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.springframework.web.reactive.function.client.WebClientResponseException;

public class EasyHttpExceptions {
    public static Optional<EasyResilienceException> easyEasyResilienceException(Throwable e) {
        if (e instanceof RequestTimeoutException) {
            return Optional.of(new EasyResilienceRequestTimeoutException(e));
        }
        if (e instanceof OverflowException) {
            return Optional.of(new EasyResilienceOverflowException(e));
        }
        if (e instanceof CircuitOpenException) {
            return Optional.of(new EasyResilienceCircuitOpenException(e));
        }
        if (e instanceof ResilienceException) {
            return Optional.of(new EasyResilienceException(e));
        }
        return Optional.empty();
    }

    public static EasyHttpRequestException convert(int statusCode, Throwable throwable, ResponseObject responseObject) {
        EasyHttpRequestException exception = EasyHttpExceptions.easyEasyResilienceException(throwable).orElse(null);
        if (exception != null) {
            return exception;
        }
        if (throwable instanceof ReadTimeoutException || throwable instanceof SocketTimeoutException) {
            return new EasyRequestTimeOutException(responseObject);
        }
        if (throwable != null && throwable.getCause() instanceof ReadTimeoutException) {
            return new EasyRequestTimeOutException(responseObject);
        }
        if (throwable instanceof WebClientResponseException) {
            WebClientResponseException ex = (WebClientResponseException)throwable;
            statusCode = ex.getRawStatusCode();
        }
        exception = statusCode == Response.Status.GATEWAY_TIMEOUT.getStatusCode() ? new EasyGatewayTimeoutException(responseObject) : (statusCode == Response.Status.SERVICE_UNAVAILABLE.getStatusCode() ? new EasyServiceUnavailableException(responseObject) : (statusCode == Response.Status.BAD_GATEWAY.getStatusCode() ? new EasyBadGatewayException(responseObject) : (statusCode == Response.Status.NOT_IMPLEMENTED.getStatusCode() ? new EasyNotImplementedException(responseObject) : (statusCode == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() ? new EasyInternalServerErrorException(responseObject) : (statusCode == 429 ? new EasyTooManyRequestsException(responseObject) : (statusCode == 422 ? new EasyBadRequestException(responseObject) : (statusCode == Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode() ? new EasyBadRequestException(responseObject) : (statusCode == Response.Status.GONE.getStatusCode() ? new EasyGoneException(responseObject) : (statusCode == Response.Status.CONFLICT.getStatusCode() ? new EasyConflictRequestException(responseObject) : (statusCode == Response.Status.NOT_ACCEPTABLE.getStatusCode() ? new EasyNotAcceptableException(responseObject) : (statusCode == Response.Status.METHOD_NOT_ALLOWED.getStatusCode() ? new EasyMethodNotAllowedException(responseObject) : (statusCode == Response.Status.NOT_FOUND.getStatusCode() ? new EasyNotFoundException(responseObject) : (statusCode == Response.Status.FORBIDDEN.getStatusCode() ? new EasyUnauthorizedRequestException(responseObject) : (statusCode == Response.Status.UNAUTHORIZED.getStatusCode() ? new EasyUnauthorizedRequestException(responseObject) : (statusCode == Response.Status.BAD_REQUEST.getStatusCode() ? new EasyBadRequestException(responseObject) : new EasyHttpRequestException(responseObject))))))))))))))));
        return exception;
    }

    public static class EasyResilienceRequestTimeoutException
    extends EasyResilienceException {
        public EasyResilienceRequestTimeoutException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class EasyResilienceOverflowException
    extends EasyResilienceException {
        public EasyResilienceOverflowException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class EasyResilienceCircuitOpenException
    extends EasyResilienceException {
        public EasyResilienceCircuitOpenException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class EasyResilienceException
    extends EasyHttpRequestException {
        public EasyResilienceException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class EasyHttpRequestException
    extends RuntimeException {
        private final int statusCode;
        private final byte[] body;
        private final ResponseObject response;

        public EasyHttpRequestException(Throwable throwable) {
            super(throwable);
            this.statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
            this.body = null;
            this.response = null;
        }

        public EasyHttpRequestException(String message, ResponseObject response) {
            super(message, response.getException() != null ? response.getException() : null);
            this.statusCode = response.getStatusCode();
            this.body = response.getBody();
            this.response = response;
        }

        public EasyHttpRequestException(ResponseObject response) {
            this(String.format("statusCode=%d", response.getStatusCode()), response);
        }

        @JsonIgnore
        public String getResponseAsString() {
            return this.response != null ? this.response.getBodyAsString() : null;
        }

        @JsonIgnore
        public Map<String, Object> getResponseAsMap() {
            return this.response != null ? this.response.convertAsMap() : null;
        }

        public static EasyHttpRequestExceptionBuilder builder() {
            return new EasyHttpRequestExceptionBuilder();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public byte[] getBody() {
            return this.body;
        }

        public ResponseObject getResponse() {
            return this.response;
        }

        public EasyHttpRequestException(int statusCode, byte[] body, ResponseObject response) {
            this.statusCode = statusCode;
            this.body = body;
            this.response = response;
        }

        public static class EasyHttpRequestExceptionBuilder {
            private int statusCode;
            private byte[] body;
            private ResponseObject response;

            EasyHttpRequestExceptionBuilder() {
            }

            public EasyHttpRequestExceptionBuilder statusCode(int statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            public EasyHttpRequestExceptionBuilder body(byte[] body) {
                this.body = body;
                return this;
            }

            public EasyHttpRequestExceptionBuilder response(ResponseObject response) {
                this.response = response;
                return this;
            }

            public EasyHttpRequestException build() {
                return new EasyHttpRequestException(this.statusCode, this.body, this.response);
            }

            public String toString() {
                return "EasyHttpExceptions.EasyHttpRequestException.EasyHttpRequestExceptionBuilder(statusCode=" + this.statusCode + ", body=" + Arrays.toString(this.body) + ", response=" + String.valueOf(this.response) + ")";
            }
        }
    }

    public static class EasyRequestTimeOutException
    extends Easy4xxException {
        public EasyRequestTimeOutException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyGatewayTimeoutException
    extends Easy5xxException {
        public EasyGatewayTimeoutException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyServiceUnavailableException
    extends Easy5xxException {
        public EasyServiceUnavailableException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyBadGatewayException
    extends Easy5xxException {
        public EasyBadGatewayException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyNotImplementedException
    extends Easy5xxException {
        public EasyNotImplementedException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyInternalServerErrorException
    extends Easy5xxException {
        public EasyInternalServerErrorException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyTooManyRequestsException
    extends Easy4xxException {
        public EasyTooManyRequestsException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyBadRequestException
    extends Easy4xxException {
        public EasyBadRequestException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyGoneException
    extends Easy4xxException {
        public EasyGoneException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyConflictRequestException
    extends Easy4xxException {
        public EasyConflictRequestException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyNotAcceptableException
    extends Easy4xxException {
        public EasyNotAcceptableException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyMethodNotAllowedException
    extends Easy4xxException {
        public EasyMethodNotAllowedException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyNotFoundException
    extends Easy4xxException {
        public EasyNotFoundException(ResponseObject response) {
            super(response);
        }
    }

    public static class EasyUnauthorizedRequestException
    extends Easy4xxException {
        public EasyUnauthorizedRequestException(ResponseObject response) {
            super(response);
        }
    }

    public static class Easy5xxException
    extends EasyHttpRequestException {
        public Easy5xxException(ResponseObject response) {
            super(response);
        }
    }

    public static class Easy4xxException
    extends EasyHttpRequestException {
        public Easy4xxException(ResponseObject response) {
            super(response);
        }
    }
}

