/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.http.registry;

import com.google.inject.Inject;
import io.gitbub.devlibx.easy.helper.Safe;
import io.github.devlibx.easy.http.config.Api;
import io.github.devlibx.easy.http.config.Config;
import io.github.devlibx.easy.http.config.Server;
import io.github.devlibx.easy.http.helper.IClientBuilder;
import io.github.devlibx.easy.http.module.Async;
import io.github.devlibx.easy.http.module.Sync;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.web.reactive.function.client.WebClient;

public class ApiRegistry {
    private final Map<String, Api> apiMap;
    private final IClientBuilder httpClientBuilder;
    private final IClientBuilder asyncHttpClientBuilder;

    @Inject
    public ApiRegistry(@Sync IClientBuilder httpClientBuilder, @Async IClientBuilder asyncHttpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
        this.asyncHttpClientBuilder = asyncHttpClientBuilder;
        this.apiMap = new HashMap<String, Api>();
    }

    public void configure(Config config) {
        this.apiMap.putAll(config.getApis());
    }

    public Optional<Api> getOptional(String api) {
        return Optional.ofNullable(this.apiMap.get(api));
    }

    public <T> T getClient(Server server, Api api, Class<T> cls) {
        if (this.httpClientBuilder.accept(server, api)) {
            return (T)this.httpClientBuilder.buildClient(server, api, CloseableHttpClient.class);
        }
        if (this.asyncHttpClientBuilder.accept(server, api)) {
            return (T)this.asyncHttpClientBuilder.buildClient(server, api, WebClient.class);
        }
        throw new RuntimeException("Request not supported");
    }

    public void shutdown() {
        Safe.safe(() -> this.httpClientBuilder.shutdown());
    }

    public Map<String, Api> getApiMap() {
        return this.apiMap;
    }
}

