/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.lock;

import io.github.devlibx.easy.lock.config.LockConfig;
import java.util.concurrent.locks.Lock;

public interface IDistributedLock {
    default public void setup(LockConfig lockConfig) {
    }

    default public void tearDown() {
    }

    public Lock achieveLock(LockRequest var1);

    public void releaseLock(Lock var1, LockRequest var2);

    default public void releaseResources() {
    }

    public static class LockRequest {
        private String name;
        private String lockId;
        private String lockGroup;

        public String getUniqueLockIdForLocking() {
            return this.lockId;
        }

        public static LockRequestBuilder builder() {
            return new LockRequestBuilder();
        }

        public String getName() {
            return this.name;
        }

        public String getLockId() {
            return this.lockId;
        }

        public String getLockGroup() {
            return this.lockGroup;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLockId(String lockId) {
            this.lockId = lockId;
        }

        public void setLockGroup(String lockGroup) {
            this.lockGroup = lockGroup;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LockRequest)) {
                return false;
            }
            LockRequest other = (LockRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$lockId = this.getLockId();
            String other$lockId = other.getLockId();
            if (this$lockId == null ? other$lockId != null : !this$lockId.equals(other$lockId)) {
                return false;
            }
            String this$lockGroup = this.getLockGroup();
            String other$lockGroup = other.getLockGroup();
            return !(this$lockGroup == null ? other$lockGroup != null : !this$lockGroup.equals(other$lockGroup));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LockRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $lockId = this.getLockId();
            result = result * 59 + ($lockId == null ? 43 : $lockId.hashCode());
            String $lockGroup = this.getLockGroup();
            result = result * 59 + ($lockGroup == null ? 43 : $lockGroup.hashCode());
            return result;
        }

        public String toString() {
            return "IDistributedLock.LockRequest(name=" + this.getName() + ", lockId=" + this.getLockId() + ", lockGroup=" + this.getLockGroup() + ")";
        }

        public LockRequest() {
        }

        public LockRequest(String name, String lockId, String lockGroup) {
            this.name = name;
            this.lockId = lockId;
            this.lockGroup = lockGroup;
        }

        public static class LockRequestBuilder {
            private String name;
            private String lockId;
            private String lockGroup;

            LockRequestBuilder() {
            }

            public LockRequestBuilder name(String name) {
                this.name = name;
                return this;
            }

            public LockRequestBuilder lockId(String lockId) {
                this.lockId = lockId;
                return this;
            }

            public LockRequestBuilder lockGroup(String lockGroup) {
                this.lockGroup = lockGroup;
                return this;
            }

            public LockRequest build() {
                return new LockRequest(this.name, this.lockId, this.lockGroup);
            }

            public String toString() {
                return "IDistributedLock.LockRequest.LockRequestBuilder(name=" + this.name + ", lockId=" + this.lockId + ", lockGroup=" + this.lockGroup + ")";
            }
        }
    }
}

