/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.lock;

import io.gitbub.devlibx.easy.helper.Safe;
import io.github.devlibx.easy.lock.IDistributedLock;
import io.github.devlibx.easy.lock.IDistributedLockService;
import io.github.devlibx.easy.lock.ILockBuilder;
import io.github.devlibx.easy.lock.config.LockConfig;
import io.github.devlibx.easy.lock.config.LockConfigs;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DistributedLockService
implements IDistributedLockService {
    private final Map<String, IDistributedLock> lockMap;
    private final LockConfigs lockConfigs;
    private final Map<String, ILockBuilder> lockBuilders;
    private boolean initialized = false;
    private final Object INITIALIZE_LOCK = new Object();

    @Inject
    public DistributedLockService(LockConfigs lockConfigs, Map<String, ILockBuilder> lockBuilders) {
        this.lockBuilders = lockBuilders;
        this.lockMap = new HashMap<String, IDistributedLock>();
        this.lockConfigs = lockConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        Object object = this.INITIALIZE_LOCK;
        synchronized (object) {
            this.lockConfigs.getLockConfigs().forEach((lock, lockConfig) -> {
                lockConfig.setName((String)lock);
                IDistributedLock distributedLock = this.lockBuilders.get(lockConfig.getType()).create((LockConfig)lockConfig);
                distributedLock.setup((LockConfig)lockConfig);
                this.lockMap.put((String)lock, distributedLock);
            });
            this.initialized = true;
        }
    }

    @Override
    public void shutdown() {
        Safe.safe(() -> this.lockMap.forEach((lock, distributedLock) -> Safe.safe(distributedLock::tearDown, (String)("failed to teardown a lock: lock=" + lock))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDistributedLock getLock(String name) {
        if (!this.initialized) {
            Object object = this.INITIALIZE_LOCK;
            synchronized (object) {
                if (!this.initialized) {
                    this.initialize();
                }
            }
        }
        if (Objects.equals("__no_op_lock_name__", name)) {
            return new IDistributedLockService.NoOpDistributedLock();
        }
        return this.lockMap.get(name);
    }
}

