/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.lock.interceptor;

import com.google.common.base.Strings;
import io.gitbub.devlibx.easy.helper.ApplicationContext;
import io.github.devlibx.easy.lock.DistributedLock;
import io.github.devlibx.easy.lock.IDistributedLock;
import io.github.devlibx.easy.lock.IDistributedLockIdResolver;
import io.github.devlibx.easy.lock.IDistributedLockService;
import java.util.concurrent.locks.Lock;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        DistributedLock distributedLock = invocation.getMethod().getAnnotation(DistributedLock.class);
        if (distributedLock == null) {
            log.trace("Execute method without lock - method is not marked with DistributedLock");
            return invocation.proceed();
        }
        IDistributedLock lock = null;
        try {
            IDistributedLockService distributedLockService = (IDistributedLockService)ApplicationContext.getInstance(IDistributedLockService.class);
            lock = distributedLockService.getLock(distributedLock.name());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                e.printStackTrace();
            }
            throw new RuntimeException("Field to find lock with name=" + distributedLock.name() + ": Make suer you added a LockConfig with this name", e);
        }
        if (lock == null) {
            throw new RuntimeException("Field to find lock with name=" + distributedLock.name() + ": Make suer you added a LockConfig with this name");
        }
        IDistributedLockIdResolver distributedLockIdResolver = (IDistributedLockIdResolver)ApplicationContext.getInstance(distributedLock.lockIdResolver());
        IDistributedLock.LockRequest lockRequest = distributedLockIdResolver.createLockRequest(invocation, invocation.getArguments());
        log.trace("Lock Request = {}, distributedLockAnnotation={}", (Object)lockRequest, (Object)distributedLock);
        if (Strings.isNullOrEmpty((String)lockRequest.getName())) {
            lockRequest.setName(distributedLock.name());
        }
        if (Strings.isNullOrEmpty((String)lockRequest.getLockGroup())) {
            lockRequest.setLockGroup(distributedLock.group());
        }
        Lock underlyingLock = null;
        try {
            log.trace("Trying to acquire lock - request={}", (Object)lockRequest);
            underlyingLock = lock.achieveLock(lockRequest);
            if (underlyingLock instanceof IDistributedLockService.ExistingLockWithNoOp) {
                log.info("acquired a existing lock: (this is a no-op lock) - lock={}", (Object)underlyingLock);
            }
            log.debug("Lock acquired - request={}", (Object)lockRequest);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (underlyingLock != null) {
                lock.releaseLock(underlyingLock, lockRequest);
                log.debug("Lock released - request={}", (Object)lockRequest);
            }
        }
    }
}

