/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.easy.messaging.service;

import io.gitbub.devlibx.easy.helper.Safe;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.easy.messaging.config.MessagingConfigs;
import io.github.devlibx.easy.messaging.consumer.IConsumer;
import io.github.devlibx.easy.messaging.consumer.IConsumerService;
import io.github.devlibx.easy.messaging.producer.IProducer;
import io.github.devlibx.easy.messaging.producer.IProducerService;
import io.github.devlibx.easy.messaging.service.IMessagingFactory;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFactory
implements IMessagingFactory {
    private static final Logger log = LoggerFactory.getLogger(MessageFactory.class);
    private final Map<String, IProducerService> producerServiceMap;
    private final Map<String, IConsumerService> consumerServiceMap;
    private final MessagingConfigs messagingConfigs;
    private boolean initialized = false;

    @Inject
    public MessageFactory(Map<String, IProducerService> producerServiceMap, Map<String, IConsumerService> consumerServiceMap, MessagingConfigs messagingConfigs) {
        this.producerServiceMap = producerServiceMap;
        this.consumerServiceMap = consumerServiceMap;
        this.messagingConfigs = messagingConfigs;
        if (messagingConfigs == null || messagingConfigs.getConsumers().isEmpty() && messagingConfigs.getProducers().isEmpty()) {
            log.error("You must bind MessagingConfigs in injector using [ bind(MessagingConfigs.class).toInstance(<config object>) ]");
            throw new RuntimeException("some misconfiguration found in messaging - it seems that MessagingConfigs is not proper. It has both producers and consumers missing. May be you did not bind MessagingConfigs in injector");
        }
    }

    @Override
    public synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.messagingConfigs.getProducers().forEach((name, config) -> {
            if (!config.getBoolean("enabled", Boolean.TRUE).booleanValue()) {
                log.info("messaging producer [{}] is not enabled", name);
                return;
            }
            String type = config.getString("type", "KAFKA");
            IProducerService producerService = this.producerServiceMap.get(type);
            if (producerService == null) {
                throw new RuntimeException("producer type " + type + " is not supported");
            }
            log.info("initialize producer [{}]", name);
            config.put((Object)"name", name);
            producerService.initialize((StringObjectMap)config);
        });
        this.messagingConfigs.getConsumers().forEach((name, config) -> {
            if (!config.getBoolean("enabled", Boolean.TRUE).booleanValue()) {
                log.info("messaging consumer [{}] is not enabled", name);
                return;
            }
            String type = config.getString("type", "KAFKA");
            IConsumerService consumerService = this.consumerServiceMap.get(type);
            if (consumerService == null) {
                throw new RuntimeException("consumer type " + type + " is not supported");
            }
            log.info("initialize consumer [{}]", name);
            config.put((Object)"name", name);
            consumerService.initialize((StringObjectMap)config);
        });
        this.initialized = true;
    }

    @Override
    public Optional<IProducer> getProducer(String name) {
        StringObjectMap config;
        if (!this.initialized) {
            this.initialize();
        }
        if ((config = this.messagingConfigs.getProducers().get(name)) == null) {
            return Optional.empty();
        }
        IProducerService producerService = this.producerServiceMap.get(config.getString("type", "KAFKA"));
        return producerService.getProducer(name);
    }

    @Override
    public Optional<IConsumer> getConsumer(String name) {
        StringObjectMap config;
        if (!this.initialized) {
            this.initialize();
        }
        if ((config = this.messagingConfigs.getConsumers().get(name)) == null) {
            return Optional.empty();
        }
        IConsumerService consumerService = this.consumerServiceMap.get(config.getString("type", "KAFKA"));
        return consumerService.getConsumer(name);
    }

    @Override
    public void shutdown() {
        this.producerServiceMap.forEach((type, producerService) -> Safe.safe(producerService::shutdown));
        this.consumerServiceMap.forEach((type, consumerService) -> Safe.safe(consumerService::shutdown));
    }
}

