/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.miscellaneous.util.aggregation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.miscellaneous.util.aggregation.TimeWindowDataAggregation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class TimeWindowDataAggregationHelper<T> {
    private final int daysCount;
    private final int daysHoursCount;
    private final int hoursCount;
    private final int minutesCount;

    public TimeWindowDataAggregationHelper(Config config) {
        this.hoursCount = config.hourAggregationWindow;
        this.minutesCount = config.minuteAggregationWindow;
        if (config.getDayHourAggregationWindow() > 0) {
            this.daysCount = 0;
            this.daysHoursCount = config.dayHourAggregationWindow;
        } else {
            this.daysCount = config.dayAggregationWindow;
            this.daysHoursCount = 0;
        }
    }

    public void process(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        this.processDayHour(aggregation, currentTime, event, eventTime, updater);
        this.processDay(aggregation, currentTime, event, eventTime, updater);
        this.processHours(aggregation, currentTime, event, eventTime, updater);
        this.processMinutes(aggregation, currentTime, event, eventTime, updater);
    }

    void processDayHour(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.daysHoursCount <= 0) {
            return;
        }
        List<String> keysToRemove = this.getDayHourKeys(currentTime);
        Set keysInInput = aggregation.getDaysHours().keySet();
        keysInInput.forEach(keysToRemove::remove);
        keysToRemove.forEach(keyToRemove -> updater.expired(aggregation.getDaysHours(), (String)keyToRemove, event));
        String key = eventTime.getMonthOfYear() + "-" + eventTime.getDayOfMonth();
        if (this.getDayHourKeys(currentTime).contains(key)) {
            if (!aggregation.getDaysHours().containsKey((Object)key)) {
                aggregation.getDaysHours().put((Object)key, (Object)new StringObjectMap());
            }
            StringObjectMap dayData = aggregation.getDaysHours().getStringObjectMap(key);
            updater.update(dayData, eventTime.getHourOfDay() + "", event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    void processDay(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.daysCount <= 0) {
            return;
        }
        List<String> keysToRemove = this.getDayKeys(currentTime);
        Set keysInInput = aggregation.getDays().keySet();
        keysInInput.forEach(keysToRemove::remove);
        keysToRemove.forEach(keyToRemove -> updater.expired(aggregation.getDays(), (String)keyToRemove, event));
        String key = eventTime.getMonthOfYear() + "-" + eventTime.getDayOfMonth();
        if (this.getDayKeys(currentTime).contains(key)) {
            updater.update(aggregation.getDays(), key, event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    void processHours(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.hoursCount <= 0) {
            return;
        }
        List<String> keysToRemove = this.getHoursKeys(currentTime);
        Set keysInInput = aggregation.getHours().keySet();
        keysInInput.forEach(keysToRemove::remove);
        keysToRemove.forEach(keyToRemove -> updater.expired(aggregation.getHours(), (String)keyToRemove, event));
        String key = eventTime.getDayOfMonth() + "-" + eventTime.getHourOfDay();
        if (this.getHoursKeys(currentTime).contains(key)) {
            updater.update(aggregation.getHours(), key, event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    void processMinutes(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.minutesCount <= 0) {
            return;
        }
        List<String> keysToRemove = this.getMinuetKeys(currentTime);
        Set keysInInput = aggregation.getMinutes().keySet();
        keysInInput.forEach(keysToRemove::remove);
        keysToRemove.forEach(keyToRemove -> updater.expired(aggregation.getMinutes(), (String)keyToRemove, event));
        String key = eventTime.getHourOfDay() + "-" + eventTime.getMinuteOfHour();
        if (this.getMinuetKeys(currentTime).contains(key)) {
            updater.update(aggregation.getMinutes(), key, event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    List<String> getDayKeys(DateTime time) {
        DateTime start = time.minusDays(this.daysCount);
        ArrayList<String> keys = new ArrayList<String>();
        while (start.isBefore((ReadableInstant)time)) {
            start = start.plusDays(1);
            String dayKey = start.getMonthOfYear() + "-" + start.getDayOfMonth();
            keys.add(dayKey);
        }
        return keys;
    }

    List<String> getDayHourKeys(DateTime time) {
        DateTime start = time.minusDays(this.daysHoursCount);
        ArrayList<String> keys = new ArrayList<String>();
        while (start.isBefore((ReadableInstant)time)) {
            start = start.plusDays(1);
            String dayKey = start.getMonthOfYear() + "-" + start.getDayOfMonth();
            keys.add(dayKey);
        }
        return keys;
    }

    List<String> getHoursKeys(DateTime time) {
        DateTime start = time.minusHours(this.hoursCount);
        ArrayList<String> keys = new ArrayList<String>();
        while (start.isBefore((ReadableInstant)time)) {
            start = start.plusHours(1);
            String dayKey = start.getDayOfMonth() + "-" + start.getHourOfDay();
            keys.add(dayKey);
        }
        return keys;
    }

    List<String> getMinuetKeys(DateTime time) {
        DateTime start = time.minusMinutes(this.minutesCount);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < 60; ++i) {
            start = start.plusMinutes(1);
            String dayKey = start.getHourOfDay() + "-" + start.getMinuteOfHour();
            keys.add(dayKey);
        }
        return keys;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Config {
        private int dayAggregationWindow;
        private int dayHourAggregationWindow;
        private int hourAggregationWindow;
        private int minuteAggregationWindow;

        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        public int getDayAggregationWindow() {
            return this.dayAggregationWindow;
        }

        public int getDayHourAggregationWindow() {
            return this.dayHourAggregationWindow;
        }

        public int getHourAggregationWindow() {
            return this.hourAggregationWindow;
        }

        public int getMinuteAggregationWindow() {
            return this.minuteAggregationWindow;
        }

        public void setDayAggregationWindow(int dayAggregationWindow) {
            this.dayAggregationWindow = dayAggregationWindow;
        }

        public void setDayHourAggregationWindow(int dayHourAggregationWindow) {
            this.dayHourAggregationWindow = dayHourAggregationWindow;
        }

        public void setHourAggregationWindow(int hourAggregationWindow) {
            this.hourAggregationWindow = hourAggregationWindow;
        }

        public void setMinuteAggregationWindow(int minuteAggregationWindow) {
            this.minuteAggregationWindow = minuteAggregationWindow;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDayAggregationWindow() != other.getDayAggregationWindow()) {
                return false;
            }
            if (this.getDayHourAggregationWindow() != other.getDayHourAggregationWindow()) {
                return false;
            }
            if (this.getHourAggregationWindow() != other.getHourAggregationWindow()) {
                return false;
            }
            return this.getMinuteAggregationWindow() == other.getMinuteAggregationWindow();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDayAggregationWindow();
            result = result * 59 + this.getDayHourAggregationWindow();
            result = result * 59 + this.getHourAggregationWindow();
            result = result * 59 + this.getMinuteAggregationWindow();
            return result;
        }

        public String toString() {
            return "TimeWindowDataAggregationHelper.Config(dayAggregationWindow=" + this.getDayAggregationWindow() + ", dayHourAggregationWindow=" + this.getDayHourAggregationWindow() + ", hourAggregationWindow=" + this.getHourAggregationWindow() + ", minuteAggregationWindow=" + this.getMinuteAggregationWindow() + ")";
        }

        public Config() {
        }

        public Config(int dayAggregationWindow, int dayHourAggregationWindow, int hourAggregationWindow, int minuteAggregationWindow) {
            this.dayAggregationWindow = dayAggregationWindow;
            this.dayHourAggregationWindow = dayHourAggregationWindow;
            this.hourAggregationWindow = hourAggregationWindow;
            this.minuteAggregationWindow = minuteAggregationWindow;
        }

        public static class ConfigBuilder {
            private int dayAggregationWindow;
            private int dayHourAggregationWindow;
            private int hourAggregationWindow;
            private int minuteAggregationWindow;

            ConfigBuilder() {
            }

            public ConfigBuilder dayAggregationWindow(int dayAggregationWindow) {
                this.dayAggregationWindow = dayAggregationWindow;
                return this;
            }

            public ConfigBuilder dayHourAggregationWindow(int dayHourAggregationWindow) {
                this.dayHourAggregationWindow = dayHourAggregationWindow;
                return this;
            }

            public ConfigBuilder hourAggregationWindow(int hourAggregationWindow) {
                this.hourAggregationWindow = hourAggregationWindow;
                return this;
            }

            public ConfigBuilder minuteAggregationWindow(int minuteAggregationWindow) {
                this.minuteAggregationWindow = minuteAggregationWindow;
                return this;
            }

            public Config build() {
                return new Config(this.dayAggregationWindow, this.dayHourAggregationWindow, this.hourAggregationWindow, this.minuteAggregationWindow);
            }

            public String toString() {
                return "TimeWindowDataAggregationHelper.Config.ConfigBuilder(dayAggregationWindow=" + this.dayAggregationWindow + ", dayHourAggregationWindow=" + this.dayHourAggregationWindow + ", hourAggregationWindow=" + this.hourAggregationWindow + ", minuteAggregationWindow=" + this.minuteAggregationWindow + ")";
            }
        }
    }

    static interface IAggregationUpdater<T> {
        public void update(StringObjectMap var1, String var2, T var3);

        default public void expired(StringObjectMap data, String key, T event) {
            data.remove((Object)key);
        }
    }
}

