/*
 * Decompiled with CFR 0.152.
 */
package io.github.devlibx.miscellaneous.util.aggregation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.gitbub.devlibx.easy.helper.map.StringObjectMap;
import io.github.devlibx.miscellaneous.util.aggregation.TimeWindowDataAggregation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class TimeWindowDataAggregationHelper<T> {
    private final int daysCount;
    private final int daysHoursCount;
    private final int hoursCount;
    private final int minutesCount;

    public TimeWindowDataAggregationHelper(Config config) {
        this.hoursCount = config.hourAggregationWindow;
        this.minutesCount = config.minuteAggregationWindow;
        if (config.getDayHourAggregationWindow() > 0) {
            this.daysCount = 0;
            this.daysHoursCount = config.dayHourAggregationWindow;
        } else {
            this.daysCount = config.dayAggregationWindow;
            this.daysHoursCount = 0;
        }
    }

    public void process(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        this.processDayHour(aggregation, currentTime, event, eventTime, updater);
        this.processDay(aggregation, currentTime, event, eventTime, updater);
        this.processHours(aggregation, currentTime, event, eventTime, updater);
        this.processMinutes(aggregation, currentTime, event, eventTime, updater);
    }

    void processDayHour(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.daysHoursCount <= 0) {
            return;
        }
        int keysCount = this.getDaysSinceLastUpdate(currentTime, aggregation);
        if (keysCount > this.daysHoursCount) {
            aggregation.getDaysHours().clear();
            keysCount = 0;
        }
        List<String> retainKeys = this.getDayHourKeys(new DateTime(aggregation.getUpdatedAt()), this.daysHoursCount - keysCount);
        HashSet removeKeys = new HashSet(aggregation.getDaysHours().keySet());
        removeKeys.removeAll(retainKeys);
        removeKeys.forEach(removeKey -> updater.expired(aggregation.getDaysHours(), (String)removeKey, event));
        String key = eventTime.getMonthOfYear() + "-" + eventTime.getDayOfMonth();
        if (eventTime.isAfter((ReadableInstant)currentTime.minusDays(this.daysHoursCount)) && !eventTime.isAfter((ReadableInstant)currentTime)) {
            if (!aggregation.getDaysHours().containsKey((Object)key)) {
                aggregation.getDaysHours().put((Object)key, (Object)new StringObjectMap());
            }
            StringObjectMap dayData = aggregation.getDaysHours().getStringObjectMap(key);
            updater.update(dayData, eventTime.getHourOfDay() + "", event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    void processDay(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.daysCount <= 0) {
            return;
        }
        int keysCount = this.getDaysSinceLastUpdate(currentTime, aggregation);
        if (keysCount > this.daysCount) {
            aggregation.getDays().clear();
            keysCount = 0;
        }
        List<String> retainKeys = this.getDayKeys(new DateTime(aggregation.getUpdatedAt()), this.daysCount - keysCount);
        HashSet removeKeys = new HashSet(aggregation.getDays().keySet());
        removeKeys.removeAll(retainKeys);
        removeKeys.forEach(removeKey -> updater.expired(aggregation.getDays(), (String)removeKey, event));
        String key = eventTime.getMonthOfYear() + "-" + eventTime.getDayOfMonth();
        if (eventTime.isAfter((ReadableInstant)currentTime.minusDays(this.daysCount)) && !eventTime.isAfter((ReadableInstant)currentTime)) {
            updater.update(aggregation.getDays(), key, event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    void processHours(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.hoursCount <= 0) {
            return;
        }
        int keysCount = this.getHoursSinceLastUpdate(currentTime, aggregation);
        if (keysCount > this.hoursCount) {
            aggregation.getHours().clear();
            keysCount = 0;
        }
        List<String> retainKeys = this.getHoursKeys(new DateTime(aggregation.getUpdatedAt()), this.hoursCount - keysCount);
        HashSet removeKeys = new HashSet(aggregation.getHours().keySet());
        removeKeys.removeAll(retainKeys);
        removeKeys.forEach(removeKey -> updater.expired(aggregation.getHours(), (String)removeKey, event));
        String key = eventTime.getDayOfMonth() + "-" + eventTime.getHourOfDay();
        if (eventTime.isAfter((ReadableInstant)currentTime.minusHours(this.hoursCount)) && !eventTime.isAfter((ReadableInstant)currentTime)) {
            updater.update(aggregation.getHours(), key, event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    void processMinutes(TimeWindowDataAggregation aggregation, DateTime currentTime, T event, DateTime eventTime, IAggregationUpdater<T> updater) {
        if (this.minutesCount <= 0) {
            return;
        }
        int keysCount = this.getMinutesSinceLastUpdate(currentTime, aggregation);
        if (keysCount > this.minutesCount) {
            aggregation.getMinutes().clear();
            keysCount = 0;
        }
        List<String> retainKeys = this.getMinuteKeys(new DateTime(aggregation.getUpdatedAt()), this.minutesCount - keysCount);
        HashSet removeKeys = new HashSet(aggregation.getMinutes().keySet());
        removeKeys.removeAll(retainKeys);
        removeKeys.forEach(removeKey -> updater.expired(aggregation.getMinutes(), (String)removeKey, event));
        String key = eventTime.getHourOfDay() + "-" + eventTime.getMinuteOfHour();
        if (eventTime.isAfter((ReadableInstant)currentTime.minusMinutes(this.minutesCount)) && !eventTime.isAfter((ReadableInstant)currentTime)) {
            updater.update(aggregation.getMinutes(), key, event);
        }
        aggregation.setUpdatedAt(DateTime.now().getMillis());
    }

    List<String> getDayKeys(DateTime time) {
        return this.getDayKeys(time, this.daysCount);
    }

    List<String> getDayKeys(DateTime time, int keysCount) {
        DateTime start = time.minusDays(keysCount);
        ArrayList<String> keys = new ArrayList<String>();
        while (start.isBefore((ReadableInstant)time)) {
            start = start.plusDays(1);
            String dayKey = start.getMonthOfYear() + "-" + start.getDayOfMonth();
            keys.add(dayKey);
        }
        return keys;
    }

    List<String> getDayHourKeys(DateTime time) {
        return this.getDayHourKeys(time, this.daysHoursCount);
    }

    List<String> getDayHourKeys(DateTime time, int keysCount) {
        DateTime start = time.minusDays(keysCount);
        ArrayList<String> keys = new ArrayList<String>();
        while (start.isBefore((ReadableInstant)time)) {
            start = start.plusDays(1);
            String dayKey = start.getMonthOfYear() + "-" + start.getDayOfMonth();
            keys.add(dayKey);
        }
        return keys;
    }

    List<String> getHoursKeys(DateTime time) {
        return this.getHoursKeys(time, this.hoursCount);
    }

    List<String> getHoursKeys(DateTime time, int keysCount) {
        DateTime start = time.minusHours(keysCount);
        ArrayList<String> keys = new ArrayList<String>();
        while (start.isBefore((ReadableInstant)time)) {
            start = start.plusHours(1);
            String dayKey = start.getDayOfMonth() + "-" + start.getHourOfDay();
            keys.add(dayKey);
        }
        return keys;
    }

    List<String> getMinuteKeys(DateTime time) {
        return this.getMinuteKeys(time, this.minutesCount);
    }

    List<String> getMinuteKeys(DateTime time, int keysCount) {
        DateTime start = time.minusMinutes(keysCount);
        ArrayList<String> keys = new ArrayList<String>();
        while (start.isBefore((ReadableInstant)time)) {
            start = start.plusMinutes(1);
            String dayKey = start.getHourOfDay() + "-" + start.getMinuteOfHour();
            keys.add(dayKey);
        }
        return keys;
    }

    int getMinutesSinceLastUpdate(DateTime currentTime, TimeWindowDataAggregation aggregation) {
        return (int)((currentTime.getMillis() - aggregation.getUpdatedAt()) / 1000L) / 60;
    }

    int getHoursSinceLastUpdate(DateTime currentTime, TimeWindowDataAggregation aggregation) {
        return (int)((currentTime.getMillis() - aggregation.getUpdatedAt()) / 1000L / 60L) / 60;
    }

    int getDaysSinceLastUpdate(DateTime currentTime, TimeWindowDataAggregation aggregation) {
        return (int)((currentTime.getMillis() - aggregation.getUpdatedAt()) / 1000L / 60L / 60L) / 24;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Config {
        private int dayAggregationWindow;
        private int dayHourAggregationWindow;
        private int hourAggregationWindow;
        private int minuteAggregationWindow;

        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        public int getDayAggregationWindow() {
            return this.dayAggregationWindow;
        }

        public int getDayHourAggregationWindow() {
            return this.dayHourAggregationWindow;
        }

        public int getHourAggregationWindow() {
            return this.hourAggregationWindow;
        }

        public int getMinuteAggregationWindow() {
            return this.minuteAggregationWindow;
        }

        public void setDayAggregationWindow(int dayAggregationWindow) {
            this.dayAggregationWindow = dayAggregationWindow;
        }

        public void setDayHourAggregationWindow(int dayHourAggregationWindow) {
            this.dayHourAggregationWindow = dayHourAggregationWindow;
        }

        public void setHourAggregationWindow(int hourAggregationWindow) {
            this.hourAggregationWindow = hourAggregationWindow;
        }

        public void setMinuteAggregationWindow(int minuteAggregationWindow) {
            this.minuteAggregationWindow = minuteAggregationWindow;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDayAggregationWindow() != other.getDayAggregationWindow()) {
                return false;
            }
            if (this.getDayHourAggregationWindow() != other.getDayHourAggregationWindow()) {
                return false;
            }
            if (this.getHourAggregationWindow() != other.getHourAggregationWindow()) {
                return false;
            }
            return this.getMinuteAggregationWindow() == other.getMinuteAggregationWindow();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDayAggregationWindow();
            result = result * 59 + this.getDayHourAggregationWindow();
            result = result * 59 + this.getHourAggregationWindow();
            result = result * 59 + this.getMinuteAggregationWindow();
            return result;
        }

        public String toString() {
            return "TimeWindowDataAggregationHelper.Config(dayAggregationWindow=" + this.getDayAggregationWindow() + ", dayHourAggregationWindow=" + this.getDayHourAggregationWindow() + ", hourAggregationWindow=" + this.getHourAggregationWindow() + ", minuteAggregationWindow=" + this.getMinuteAggregationWindow() + ")";
        }

        public Config() {
        }

        public Config(int dayAggregationWindow, int dayHourAggregationWindow, int hourAggregationWindow, int minuteAggregationWindow) {
            this.dayAggregationWindow = dayAggregationWindow;
            this.dayHourAggregationWindow = dayHourAggregationWindow;
            this.hourAggregationWindow = hourAggregationWindow;
            this.minuteAggregationWindow = minuteAggregationWindow;
        }

        public static class ConfigBuilder {
            private int dayAggregationWindow;
            private int dayHourAggregationWindow;
            private int hourAggregationWindow;
            private int minuteAggregationWindow;

            ConfigBuilder() {
            }

            public ConfigBuilder dayAggregationWindow(int dayAggregationWindow) {
                this.dayAggregationWindow = dayAggregationWindow;
                return this;
            }

            public ConfigBuilder dayHourAggregationWindow(int dayHourAggregationWindow) {
                this.dayHourAggregationWindow = dayHourAggregationWindow;
                return this;
            }

            public ConfigBuilder hourAggregationWindow(int hourAggregationWindow) {
                this.hourAggregationWindow = hourAggregationWindow;
                return this;
            }

            public ConfigBuilder minuteAggregationWindow(int minuteAggregationWindow) {
                this.minuteAggregationWindow = minuteAggregationWindow;
                return this;
            }

            public Config build() {
                return new Config(this.dayAggregationWindow, this.dayHourAggregationWindow, this.hourAggregationWindow, this.minuteAggregationWindow);
            }

            public String toString() {
                return "TimeWindowDataAggregationHelper.Config.ConfigBuilder(dayAggregationWindow=" + this.dayAggregationWindow + ", dayHourAggregationWindow=" + this.dayHourAggregationWindow + ", hourAggregationWindow=" + this.hourAggregationWindow + ", minuteAggregationWindow=" + this.minuteAggregationWindow + ")";
            }
        }
    }

    public static interface IAggregationUpdater<T> {
        public void update(StringObjectMap var1, String var2, T var3);

        default public void expired(StringObjectMap data, String key, T event) {
            data.remove((Object)key);
        }
    }
}

