/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.git.helper;

import io.github.devopsplugin.git.vo.BlobWrapper;
import io.github.devopsplugin.git.vo.DiffEntryWrapper;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class DiffHelper {
    private static final DiffAlgorithm DIFF_ALGORITHM = new HistogramDiff();
    private static final Field DIFF_ENTRY_OLD_ID_FIELD = DiffHelper.getField(DiffEntry.class, "oldId");
    private static final Field DIFF_ENTRY_NEW_ID_FIELD = DiffHelper.getField(DiffEntry.class, "newId");
    private static final Method DIFF_ENTRY_ADD_METHOD = DiffHelper.getDiffEntryAddMethod();
    private static final Method DIFF_ENTRY_MODIFY_METHOD = DiffHelper.getDiffEntryModifyMethod();
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] BINARY = new byte[0];
    private static final RawTextComparator RAW_TEXT_COMPARATOR = RawTextComparator.DEFAULT;
    private static final int BIG_FILE_THRESHOLD = 0xA00000;

    public static List<DiffEntryWrapper> calculateDiff(File gitDir, String oldRev, String newRev, boolean includeStagedCodes) throws Exception {
        try (Git git = Git.open((File)gitDir);){
            ObjectReader reader = git.getRepository().newObjectReader();
            RevWalk revWalk = new RevWalk(git.getRepository());
            RevCommit oldCommit = revWalk.parseCommit((AnyObjectId)git.getRepository().resolve(oldRev));
            RevCommit newCommit = revWalk.parseCommit((AnyObjectId)git.getRepository().resolve(newRev));
            ArrayList<DiffEntryWrapper> wrappers = new ArrayList<DiffEntryWrapper>();
            if (includeStagedCodes) {
                wrappers.addAll(DiffHelper.doCalculateIndexedDiff(git, oldCommit, reader, gitDir));
            }
            Set<String> indexedPaths = wrappers.stream().map(DiffEntryWrapper::getNewPath).collect(Collectors.toSet());
            wrappers.addAll(DiffHelper.doCalculateCommitDiff(oldCommit, newCommit, reader, git, gitDir, indexedPaths));
            ArrayList<DiffEntryWrapper> arrayList = wrappers;
            return arrayList;
        }
    }

    private static List<DiffEntryWrapper> doCalculateCommitDiff(RevCommit oldCommit, RevCommit newCommit, ObjectReader reader, Git git, File gitDir, Collection<String> excludedPaths) throws Exception {
        if (Objects.equals(oldCommit.getId(), newCommit.getId())) {
            return Collections.emptyList();
        }
        if (Objects.equals(oldCommit.getTree().getId(), newCommit.getTree().getId())) {
            return Collections.emptyList();
        }
        RenameDetector detector = new RenameDetector(git.getRepository());
        CanonicalTreeParser oldTree = new CanonicalTreeParser(null, reader, (AnyObjectId)oldCommit.getTree());
        CanonicalTreeParser newTree = new CanonicalTreeParser(null, reader, (AnyObjectId)newCommit.getTree());
        List entries = git.diff().setOldTree((AbstractTreeIterator)oldTree).setNewTree((AbstractTreeIterator)newTree).call();
        detector.reset();
        detector.addAll((Collection)entries);
        entries = detector.compute();
        return entries.stream().filter(entry -> !excludedPaths.contains(entry.getNewPath())).map(entry -> {
            RawText oldText = DiffHelper.newRawText(entry, DiffEntry.Side.OLD, reader);
            RawText newText = DiffHelper.newRawText(entry, DiffEntry.Side.NEW, reader);
            return DiffEntryWrapper.builder().gitDir(gitDir).diffEntry((DiffEntry)entry).edits(DiffHelper.calculateEditList(oldText, newText)).build();
        }).collect(Collectors.toList());
    }

    private static List<DiffEntryWrapper> doCalculateIndexedDiff(Git git, RevCommit oldCommit, ObjectReader reader, File gitDir) throws Exception {
        HashSet<String> indexedPathSet = new HashSet<String>();
        Status status = git.status().call();
        indexedPathSet.addAll(status.getAdded());
        indexedPathSet.addAll(status.getChanged());
        Map<String, BlobWrapper> indexedFileContentMap = DiffHelper.getIndexedFileContentMap(git, indexedPathSet);
        Map<String, BlobWrapper> oldRevFileContentMap = DiffHelper.getRevFileContentMap(git, oldCommit, indexedPathSet, reader);
        return indexedPathSet.stream().map(filePath -> {
            BlobWrapper oldBlob = (BlobWrapper)oldRevFileContentMap.get(filePath);
            RawText oldText = oldBlob != null ? new RawText(oldBlob.getContent()) : RawText.EMPTY_TEXT;
            RawText newText = new RawText(((BlobWrapper)indexedFileContentMap.get(filePath)).getContent());
            DiffEntry entry = oldBlob == null ? DiffHelper.createAddDiffEntry(filePath, (AnyObjectId)oldCommit) : DiffHelper.createModifyDiffEntry(filePath);
            return DiffEntryWrapper.builder().gitDir(gitDir).diffEntry(entry).edits(DiffHelper.calculateEditList(oldText, newText)).build();
        }).collect(Collectors.toList());
    }

    private static DiffEntry createAddDiffEntry(String path, AnyObjectId id) {
        try {
            return (DiffEntry)DIFF_ENTRY_ADD_METHOD.invoke(null, path, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static DiffEntry createModifyDiffEntry(String path) {
        try {
            return (DiffEntry)DIFF_ENTRY_MODIFY_METHOD.invoke(null, path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, BlobWrapper> getRevFileContentMap(Git git, RevCommit commit, Set<String> filePaths, ObjectReader reader) throws Exception {
        if (filePaths == null || filePaths.isEmpty()) {
            return Collections.emptyMap();
        }
        PathFilter filter = filePaths.size() > 1 ? OrTreeFilter.create((Collection)filePaths.stream().map(PathFilter::create).collect(Collectors.toList())) : PathFilter.create((String)filePaths.iterator().next());
        return DiffHelper.getContentMapByTreeAndFilter(git, (AbstractTreeIterator)new CanonicalTreeParser(null, reader, (AnyObjectId)commit.getTree()), (TreeFilter)filter);
    }

    private static Map<String, BlobWrapper> getIndexedFileContentMap(Git git, Set<String> filePaths) throws Exception {
        if (filePaths == null || filePaths.isEmpty()) {
            return Collections.emptyMap();
        }
        DirCache index = git.getRepository().readDirCache();
        PathFilter filter = filePaths.size() > 1 ? OrTreeFilter.create((Collection)filePaths.stream().map(PathFilter::create).collect(Collectors.toList())) : PathFilter.create((String)filePaths.iterator().next());
        return DiffHelper.getContentMapByTreeAndFilter(git, (AbstractTreeIterator)new DirCacheIterator(index), (TreeFilter)filter);
    }

    private static Map<String, BlobWrapper> getContentMapByTreeAndFilter(Git git, AbstractTreeIterator tree, TreeFilter filter) throws Exception {
        LinkedHashMap<String, BlobWrapper> contentMap = new LinkedHashMap<String, BlobWrapper>();
        try (TreeWalk treeWalk = new TreeWalk(git.getRepository());){
            treeWalk.addTree(tree);
            treeWalk.setRecursive(true);
            treeWalk.setFilter(filter);
            while (treeWalk.next()) {
                ObjectId objectId = treeWalk.getObjectId(0);
                ObjectLoader loader = git.getRepository().open((AnyObjectId)objectId);
                BlobWrapper blobWrapper = BlobWrapper.builder().blobId((AnyObjectId)objectId).content(loader.getBytes()).build();
                contentMap.put(treeWalk.getPathString(), blobWrapper);
            }
        }
        return contentMap;
    }

    private static RawText newRawText(DiffEntry entry, DiffEntry.Side side, ObjectReader reader) {
        try {
            return new RawText(DiffHelper.open(entry, side, reader, 0xA00000));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Edit> calculateEditList(RawText oldText, RawText newText) {
        return DIFF_ALGORITHM.diff((SequenceComparator)RAW_TEXT_COMPARATOR, (Sequence)oldText, (Sequence)newText);
    }

    private static byte[] open(DiffEntry entry, DiffEntry.Side side, ObjectReader reader, int bigFileThreshold) throws Exception {
        if (entry.getMode(side) == FileMode.GITLINK) {
            return DiffHelper.writeGitLinkText(entry.getId(side));
        }
        if (entry.getMode(side) == FileMode.MISSING) {
            return EMPTY;
        }
        if (entry.getMode(side).getObjectType() != 3) {
            return EMPTY;
        }
        AbbreviatedObjectId id = entry.getId(side);
        if (!id.isComplete()) {
            Collection ids = reader.resolve(id);
            if (ids.size() == 1) {
                id = AbbreviatedObjectId.fromObjectId((AnyObjectId)((AnyObjectId)ids.iterator().next()));
                switch (side) {
                    case OLD: {
                        DIFF_ENTRY_OLD_ID_FIELD.set(entry, id);
                        break;
                    }
                    case NEW: {
                        DIFF_ENTRY_NEW_ID_FIELD.set(entry, id);
                        break;
                    }
                }
            } else {
                if (ids.size() == 0) {
                    throw new MissingObjectException(id, 3);
                }
                throw new AmbiguousObjectException(id, ids);
            }
        }
        ContentSource cs = ContentSource.create((ObjectReader)reader);
        try {
            ObjectLoader ldr = new ContentSource.Pair(cs, cs).open(side, entry);
            return ldr.getBytes(bigFileThreshold);
        }
        catch (LargeObjectException.ExceedsLimit overLimit) {
            return BINARY;
        }
        catch (LargeObjectException.ExceedsByteArrayLimit overLimit) {
            return BINARY;
        }
        catch (LargeObjectException.OutOfMemory tooBig) {
            return BINARY;
        }
        catch (LargeObjectException tooBig) {
            tooBig.setObjectId((AnyObjectId)id.toObjectId());
            throw tooBig;
        }
    }

    private static byte[] writeGitLinkText(AbbreviatedObjectId id) {
        if (ObjectId.zeroId().equals((AnyObjectId)id.toObjectId())) {
            return EMPTY;
        }
        return Constants.encodeASCII((String)("Subproject commit " + id.name() + "\n"));
    }

    private static <T> Field getField(Class<T> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getDiffEntryAddMethod() {
        try {
            Method method = DiffEntry.class.getDeclaredMethod("add", String.class, AnyObjectId.class);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getDiffEntryModifyMethod() {
        try {
            Method method = DiffEntry.class.getDeclaredMethod("modify", String.class);
            method.setAccessible(true);
            return method;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

