/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.git.vo;

import java.util.Arrays;
import org.eclipse.jgit.lib.AnyObjectId;

public class BlobWrapper {
    private AnyObjectId blobId;
    private byte[] content;

    BlobWrapper(AnyObjectId blobId, byte[] content) {
        this.blobId = blobId;
        this.content = content;
    }

    public static BlobWrapperBuilder builder() {
        return new BlobWrapperBuilder();
    }

    public AnyObjectId getBlobId() {
        return this.blobId;
    }

    public byte[] getContent() {
        return this.content;
    }

    public static class BlobWrapperBuilder {
        private AnyObjectId blobId;
        private byte[] content;

        BlobWrapperBuilder() {
        }

        public BlobWrapperBuilder blobId(AnyObjectId blobId) {
            this.blobId = blobId;
            return this;
        }

        public BlobWrapperBuilder content(byte[] content) {
            this.content = content;
            return this;
        }

        public BlobWrapper build() {
            return new BlobWrapper(this.blobId, this.content);
        }

        public String toString() {
            return "BlobWrapper.BlobWrapperBuilder(blobId=" + this.blobId + ", content=" + Arrays.toString(this.content) + ")";
        }
    }
}

