/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.git.vo;

import java.io.File;
import java.util.List;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;

public class DiffEntryWrapper {
    private File gitDir;
    private DiffEntry diffEntry;
    private List<Edit> edits;

    public boolean isDeleted() {
        return this.diffEntry.getChangeType() == DiffEntry.ChangeType.DELETE;
    }

    public boolean isAllDeletedEdits() {
        return this.edits.stream().allMatch(edit -> edit.getType() == Edit.Type.DELETE);
    }

    public String getNewPath() {
        return this.diffEntry.getNewPath();
    }

    public String getAbsoluteNewPath() {
        return this.getNewFile().getAbsolutePath();
    }

    public File getNewFile() {
        return new File(this.gitDir, this.diffEntry.getNewPath());
    }

    DiffEntryWrapper(File gitDir, DiffEntry diffEntry, List<Edit> edits) {
        this.gitDir = gitDir;
        this.diffEntry = diffEntry;
        this.edits = edits;
    }

    public static DiffEntryWrapperBuilder builder() {
        return new DiffEntryWrapperBuilder();
    }

    public File getGitDir() {
        return this.gitDir;
    }

    public DiffEntry getDiffEntry() {
        return this.diffEntry;
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    public static class DiffEntryWrapperBuilder {
        private File gitDir;
        private DiffEntry diffEntry;
        private List<Edit> edits;

        DiffEntryWrapperBuilder() {
        }

        public DiffEntryWrapperBuilder gitDir(File gitDir) {
            this.gitDir = gitDir;
            return this;
        }

        public DiffEntryWrapperBuilder diffEntry(DiffEntry diffEntry) {
            this.diffEntry = diffEntry;
            return this;
        }

        public DiffEntryWrapperBuilder edits(List<Edit> edits) {
            this.edits = edits;
            return this;
        }

        public DiffEntryWrapper build() {
            return new DiffEntryWrapper(this.gitDir, this.diffEntry, this.edits);
        }

        public String toString() {
            return "DiffEntryWrapper.DiffEntryWrapperBuilder(gitDir=" + this.gitDir + ", diffEntry=" + this.diffEntry + ", edits=" + this.edits + ")";
        }
    }
}

