package io.github.devopsplugin.git.helper;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BlameHelper {

    private static final RawTextComparator RAW_TEXT_COMPARATOR = RawTextComparator.DEFAULT;

    public static List<BlameResult> getBlames(File gitDir, Collection<String> filePaths, String startRev) throws Exception {
        try (Git git = Git.open(gitDir)) {
            RevWalk revWalk = new RevWalk(git.getRepository());
            RevCommit startCommit = revWalk.parseCommit(git.getRepository().resolve(startRev));
            List<BlameResult> blameResults = new ArrayList<>();
            for (String filePath : filePaths) {
                BlameResult result = calculateBlame(git, filePath, startCommit);
                blameResults.add(result);
            }
            return blameResults;
        }
    }

    private static BlameResult calculateBlame(Git git, String filePath, RevCommit startCommit) throws GitAPIException {
        return git.blame().setFilePath(filePath)
                .setStartCommit(startCommit)
                .setTextComparator(RAW_TEXT_COMPARATOR)
                .setFollowFileRenames(true)
                .call();
    }

}
