package io.github.devopsplugin.git.vo;

import lombok.Builder;
import lombok.Getter;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffEntry.ChangeType;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.Edit.Type;

import java.io.File;
import java.util.List;

@Getter
@Builder
public class DiffEntryWrapper {

    private File gitDir;
    private DiffEntry diffEntry;
    private List<Edit> edits;

    public boolean isDeleted() {
        return diffEntry.getChangeType() == ChangeType.DELETE;
    }

    public boolean isAllDeletedEdits() {
        return edits.stream().allMatch(edit -> edit.getType() == Type.DELETE);
    }

    public String getNewPath() {
        return diffEntry.getNewPath();
    }

    public String getAbsoluteNewPath() {
        return getNewFile().getAbsolutePath();
    }

    public File getNewFile() {
        return new File(gitDir, diffEntry.getNewPath());
    }

}
