/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.git.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class BlameHelper {
    private static final RawTextComparator RAW_TEXT_COMPARATOR = RawTextComparator.DEFAULT;

    public static List<BlameResult> getBlames(File gitDir, Collection<String> filePaths, String startRev) throws Exception {
        try (Git git = Git.open((File)gitDir);){
            RevWalk revWalk = new RevWalk(git.getRepository());
            RevCommit startCommit = revWalk.parseCommit((AnyObjectId)git.getRepository().resolve(startRev));
            ArrayList<BlameResult> blameResults = new ArrayList<BlameResult>();
            for (String filePath : filePaths) {
                BlameResult result = BlameHelper.calculateBlame(git, filePath, startCommit);
                blameResults.add(result);
            }
            ArrayList<BlameResult> arrayList = blameResults;
            return arrayList;
        }
    }

    private static BlameResult calculateBlame(Git git, String filePath, RevCommit startCommit) throws GitAPIException {
        return git.blame().setFilePath(filePath).setStartCommit((AnyObjectId)startCommit).setTextComparator(RAW_TEXT_COMPARATOR).setFollowFileRenames(true).call();
    }
}

