/*
 * Decompiled with CFR 0.152.
 */
package io.github.devopsplugin.git.helper;

import java.io.File;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class MergeHelper {
    public static String getMergeBase(File gitDir, String ref1, String ref2) throws Exception {
        try (Git git = Git.open((File)gitDir);){
            RevWalk revWalk = new RevWalk(git.getRepository());
            RevCommit commit1 = revWalk.parseCommit((AnyObjectId)git.getRepository().resolve(ref1));
            RevCommit commit2 = revWalk.parseCommit((AnyObjectId)git.getRepository().resolve(ref2));
            revWalk.setRevFilter(RevFilter.MERGE_BASE);
            revWalk.markStart(commit1);
            revWalk.markStart(commit2);
            RevCommit mergeBase = revWalk.next();
            String string = mergeBase != null ? mergeBase.name() : "";
            return string;
        }
    }
}

