package io.github.devopsplugin.jacoco.util;

import org.jacoco.core.internal.analysis.filter.Filters;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LineNumberNode;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class FilterUtil {

    private static final String FILTERS = "filters";
    private static final String MODIFIERS = "modifiers";

    public static void appendFilter(IFilter filter) throws Exception {
        IFilter[] filters = getAllFilters();
        IFilter[] newFilters = new IFilter[filters.length + 1];
        System.arraycopy(filters, 0, newFilters, 0, filters.length);
        newFilters[newFilters.length - 1] = filter;
        setAllFilters(newFilters);
    }

    private static IFilter[] getAllFilters() throws Exception {
        Field filtersField = Filters.class.getDeclaredField(FILTERS);
        filtersField.setAccessible(true);
        return (IFilter[]) filtersField.get(Filters.ALL);
    }

    private static void setAllFilters(IFilter[] filters) throws Exception {
        Field filtersField = Filters.class.getDeclaredField(FILTERS);
        filtersField.setAccessible(true);
        Field modifiersField = filtersField.getClass().getDeclaredField(MODIFIERS);
        modifiersField.setAccessible(true);
        int modifiers = filtersField.getModifiers();
        modifiersField.setInt(filtersField, modifiers & ~Modifier.FINAL);
        filtersField.set(Filters.ALL, filters);
        modifiersField.setInt(filtersField, modifiers);
    }

    public static String getClassPath(IFilterContext context) {
        int lastSlashIndex = context.getClassName().lastIndexOf(File.separator);
        String path = context.getSourceFileName();
        if (lastSlashIndex >= 0) {
            path = context.getClassName().substring(0, lastSlashIndex + 1) + context.getSourceFileName();
        }
        return path;
    }

    public static List<LineNumberNodeWrapper> collectLineNumberNodeList(InsnList instructions) {
        List<LineNumberNodeWrapper> lineNumberNodeWrappers = new ArrayList<>();
        AbstractInsnNode node = instructions.getFirst();
        while (node != instructions.getLast()) {
            if (node instanceof LineNumberNode) {
                if (CollectionUtil.isNotEmpty(lineNumberNodeWrappers)) {
                    lineNumberNodeWrappers.get(lineNumberNodeWrappers.size() - 1).setNext(node);
                }
                lineNumberNodeWrappers.add(new LineNumberNodeWrapper(LineNumberNode.class.cast(node)));
            }
            node = node.getNext();
        }
        if (CollectionUtil.isNotEmpty(lineNumberNodeWrappers)) {
            lineNumberNodeWrappers.get(lineNumberNodeWrappers.size() - 1).setNext(instructions.getLast());
        }
        return lineNumberNodeWrappers;
    }

}
