/*
 * Decompiled with CFR 0.152.
 */
package com.reborn.tasks;

import com.reborn.tasks.BaseTask;
import com.reborn.tasks.IDeferredValueTask;
import com.reborn.tasks.ITaskExecutor;
import com.reborn.tasks.TaskState;
import com.reborn.tasks.common.ICancelable;
import java.util.function.Function;

public class DeferredValueTask<T>
extends BaseTask<T>
implements IDeferredValueTask<T> {
    private final Function<IDeferredValueTask<T>, ICancelable> _callable;
    private T _result;
    private boolean _resultSet;
    private ICancelable _cancelable;

    public DeferredValueTask(Function<IDeferredValueTask<T>, ICancelable> callable, ITaskExecutor executor) {
        super(executor);
        this._callable = callable;
    }

    public DeferredValueTask(ITaskExecutor executor) {
        super(executor);
        this._callable = null;
    }

    @Override
    public T getResult() {
        this.execute();
        return this._result;
    }

    @Override
    public void setSucceeded(T result) {
        if (this._resultSet) {
            throw new IllegalStateException("cannot set success result more than once");
        }
        this._result = result;
        this._resultSet = true;
        if (this._state == TaskState.EXECUTING) {
            this.onResultSucceeded(result);
        }
    }

    @Override
    public void setErrored(Throwable throwable) {
        if (this._exception != null) {
            throw new IllegalStateException("cannot set error result more than once");
        }
        this._exception = throwable;
        if (this._state == TaskState.EXECUTING) {
            this.onResultErrored(this._exception);
        }
    }

    @Override
    public ICancelable execute() {
        this.checkForValidState("re-execute");
        this._state = TaskState.EXECUTING;
        if (this._resultSet) {
            if (this._preExecute != null) {
                this._preExecute.run();
            }
            this.onResultSucceeded(this._result);
        } else {
            if (this._preExecute != null) {
                this._preExecute.run();
            }
            if (this._callable != null) {
                this._cancelable = this._callable.apply(this);
            }
        }
        return this;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this._cancelable != null) {
            this._cancelable.cancel();
        }
    }
}

