package io.github.devsecops.engine.domain.artifact.instructions;

import io.github.devsecops.engine.core.contract.Instruction;
import lombok.AllArgsConstructor;
import lombok.Builder;

@Builder
@AllArgsConstructor
public class MavenCleanInstruction implements Instruction {
    private static final String CMD = "mvn -U -s %s clean package -DskipTests";
    private final String settings;

    @Override
    public String getCmd() {
        return String.format(CMD, settings);
    }
}
