package io.github.devsecops.engine.domain.genconfig.commands;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import static io.github.devsecops.engine.core.model.Environment.LOCAL;

@Component
@Qualifier("YAML")
public class ApplicationYamlConfigCommand extends AbstractConfigCommand {

    @Override
    public String getTemplatePath() {
        return "src/main/resources/application-template.yaml";
    }

    @Override
    public String getOutputPath() {
        return getEnv() ==null || LOCAL.equals(getEnv()) ? "src/main/resources/application.yaml" : "ci/dist/application.yaml";
    }

}
