package io.github.devsecops.engine.domain.resolver.strategy.impl;

import com.bettercloud.vault.Vault;
import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.response.LogicalResponse;
import io.github.devsecops.engine.domain.resolver.strategy.ResolverStrategy;

import java.util.Optional;

public class VaultResolverStrategy implements ResolverStrategy {

    private String appPath;
    private Logical logical;

    public VaultResolverStrategy(final Vault vault, final String appPath) {
        this.logical = vault.logical();
        this.appPath = appPath;
    }

    @Override
    public Optional<String> resolve(String propertyName) {
        try {
            final String vaultProperty = propertyName.substring(propertyName.indexOf(":") + 1, propertyName.indexOf("]"));
            final LogicalResponse read = this.logical.read(String.format("%s/%s", this.appPath, vaultProperty));
            return Optional.ofNullable(read.getData().get("value"));
        } catch(Exception e) {
            return Optional.empty();
        }
    }

}
