package io.github.devsecops.engine.domain.sonar.utils;

import io.github.devsecops.engine.domain.sonar.model.Metric;
import io.github.devsecops.engine.domain.sonar.model.MetricReport;
import lombok.AllArgsConstructor;

import java.util.Map;

import static java.util.stream.Collectors.toMap;

@AllArgsConstructor
public class SonarMeasureValidator {

    private final Map<Metric, Integer> targets;

    public Map<Metric, MetricReport> perform(Map<Metric, Integer> measures) {
        return measures.entrySet()
                .stream()
                .collect(toMap(
                    Map.Entry::getKey,
                    entry -> evaluate(entry.getKey(), entry.getValue())
                ));
    }

    private MetricReport evaluate(Metric metric, Integer value) {
        final Integer target = targets.get(metric);
        return metric.evaluate(value, target);
    }

}
