/*
 * Decompiled with CFR 0.152.
 */
package org.openea.eap.module.lowcode.controller.admin.codegen;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ZipUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.openea.eap.framework.common.pojo.CommonResult;
import org.openea.eap.framework.common.pojo.PageResult;
import org.openea.eap.framework.common.util.object.BeanUtils;
import org.openea.eap.framework.common.util.servlet.ServletUtils;
import org.openea.eap.framework.security.core.util.SecurityFrameworkUtils;
import org.openea.eap.module.infra.controller.admin.codegen.vo.CodegenCreateListReqVO;
import org.openea.eap.module.infra.controller.admin.codegen.vo.CodegenDetailRespVO;
import org.openea.eap.module.infra.controller.admin.codegen.vo.CodegenPreviewRespVO;
import org.openea.eap.module.infra.controller.admin.codegen.vo.CodegenUpdateReqVO;
import org.openea.eap.module.infra.controller.admin.codegen.vo.table.CodegenTablePageReqVO;
import org.openea.eap.module.infra.controller.admin.codegen.vo.table.CodegenTableRespVO;
import org.openea.eap.module.infra.controller.admin.codegen.vo.table.DatabaseTableRespVO;
import org.openea.eap.module.infra.convert.codegen.CodegenConvert;
import org.openea.eap.module.infra.dal.dataobject.codegen.CodegenTableDO;
import org.openea.eap.module.infra.service.codegen.CodegenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7ba1\u7406\u540e\u53f0 - \u4ee3\u7801\u751f\u6210\u5668")
@RestController
@RequestMapping(value={"/lowcode/codegen"})
@Validated
public class CodegenController2 {
    @Resource
    private CodegenService codegenService;

    @GetMapping(value={"/db/table/list"})
    @Operation(summary="\u83b7\u5f97\u6570\u636e\u5e93\u81ea\u5e26\u7684\u8868\u5b9a\u4e49\u5217\u8868", description="\u4f1a\u8fc7\u6ee4\u6389\u5df2\u7ecf\u5bfc\u5165 Codegen \u7684\u8868")
    @Parameters(value={@Parameter(name="dataSourceConfigId", description="\u6570\u636e\u6e90\u914d\u7f6e\u7684\u7f16\u53f7", required=true, example="1"), @Parameter(name="name", description="\u8868\u540d\uff0c\u6a21\u7cca\u5339\u914d", example="eap"), @Parameter(name="comment", description="\u63cf\u8ff0\uff0c\u6a21\u7cca\u5339\u914d", example="\u828b\u9053")})
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:query')")
    public CommonResult<List<DatabaseTableRespVO>> getDatabaseTableList(@RequestParam(value="dataSourceConfigId") Long dataSourceConfigId, @RequestParam(value="name", required=false) String name, @RequestParam(value="comment", required=false) String comment) {
        return CommonResult.success((Object)this.codegenService.getDatabaseTableList(dataSourceConfigId, name, comment));
    }

    @GetMapping(value={"/table/list"})
    @Operation(summary="\u83b7\u5f97\u8868\u5b9a\u4e49\u5217\u8868")
    @Parameter(name="dataSourceConfigId", description="\u6570\u636e\u6e90\u914d\u7f6e\u7684\u7f16\u53f7", required=true, example="1")
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:query')")
    public CommonResult<List<CodegenTableRespVO>> getCodegenTableList(@RequestParam(value="dataSourceConfigId") Long dataSourceConfigId) {
        List list = this.codegenService.getCodegenTableList(dataSourceConfigId);
        return CommonResult.success((Object)BeanUtils.toBean((List)list, CodegenTableRespVO.class));
    }

    @GetMapping(value={"/table/page"})
    @Operation(summary="\u83b7\u5f97\u8868\u5b9a\u4e49\u5206\u9875")
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:query')")
    public CommonResult<PageResult<CodegenTableRespVO>> getCodegenTablePage(@Valid CodegenTablePageReqVO pageReqVO) {
        PageResult pageResult = this.codegenService.getCodegenTablePage(pageReqVO);
        return CommonResult.success((Object)BeanUtils.toBean((PageResult)pageResult, CodegenTableRespVO.class));
    }

    @GetMapping(value={"/detail"})
    @Operation(summary="\u83b7\u5f97\u8868\u548c\u5b57\u6bb5\u7684\u660e\u7ec6")
    @Parameter(name="tableId", description="\u8868\u7f16\u53f7", required=true, example="1024")
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:query')")
    public CommonResult<CodegenDetailRespVO> getCodegenDetail(@RequestParam(value="tableId") Long tableId) {
        CodegenTableDO table = this.codegenService.getCodegenTable(tableId);
        List columns = this.codegenService.getCodegenColumnListByTableId(tableId);
        return CommonResult.success((Object)CodegenConvert.INSTANCE.convert(table, columns));
    }

    @Operation(summary="\u57fa\u4e8e\u6570\u636e\u5e93\u7684\u8868\u7ed3\u6784\uff0c\u521b\u5efa\u4ee3\u7801\u751f\u6210\u5668\u7684\u8868\u548c\u5b57\u6bb5\u5b9a\u4e49")
    @PostMapping(value={"/create-list"})
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:create')")
    public CommonResult<List<Long>> createCodegenList(@Valid @RequestBody CodegenCreateListReqVO reqVO) {
        return CommonResult.success((Object)this.codegenService.createCodegenList(SecurityFrameworkUtils.getLoginUserId(), reqVO));
    }

    @Operation(summary="\u66f4\u65b0\u6570\u636e\u5e93\u7684\u8868\u548c\u5b57\u6bb5\u5b9a\u4e49")
    @PutMapping(value={"/update"})
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:update')")
    public CommonResult<Boolean> updateCodegen(@Valid @RequestBody CodegenUpdateReqVO updateReqVO) {
        this.codegenService.updateCodegen(updateReqVO);
        return CommonResult.success((Object)true);
    }

    @Operation(summary="\u57fa\u4e8e\u6570\u636e\u5e93\u7684\u8868\u7ed3\u6784\uff0c\u540c\u6b65\u6570\u636e\u5e93\u7684\u8868\u548c\u5b57\u6bb5\u5b9a\u4e49")
    @PutMapping(value={"/sync-from-db"})
    @Parameter(name="tableId", description="\u8868\u7f16\u53f7", required=true, example="1024")
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:update')")
    public CommonResult<Boolean> syncCodegenFromDB(@RequestParam(value="tableId") Long tableId) {
        this.codegenService.syncCodegenFromDB(tableId);
        return CommonResult.success((Object)true);
    }

    @Operation(summary="\u5220\u9664\u6570\u636e\u5e93\u7684\u8868\u548c\u5b57\u6bb5\u5b9a\u4e49")
    @DeleteMapping(value={"/delete"})
    @Parameter(name="tableId", description="\u8868\u7f16\u53f7", required=true, example="1024")
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:delete')")
    public CommonResult<Boolean> deleteCodegen(@RequestParam(value="tableId") Long tableId) {
        this.codegenService.deleteCodegen(tableId);
        return CommonResult.success((Object)true);
    }

    @Operation(summary="\u9884\u89c8\u751f\u6210\u4ee3\u7801")
    @GetMapping(value={"/preview"})
    @Parameter(name="tableId", description="\u8868\u7f16\u53f7", required=true, example="1024")
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:preview')")
    public CommonResult<List<CodegenPreviewRespVO>> previewCodegen(@RequestParam(value="tableId") Long tableId) {
        Map codes = this.codegenService.generationCodes(tableId);
        return CommonResult.success((Object)CodegenConvert.INSTANCE.convert(codes));
    }

    @Operation(summary="\u4e0b\u8f7d\u751f\u6210\u4ee3\u7801")
    @GetMapping(value={"/download"})
    @Parameter(name="tableId", description="\u8868\u7f16\u53f7", required=true, example="1024")
    @PreAuthorize(value="@ss.hasPermission('lowcode:codegen:download')")
    public void downloadCodegen(@RequestParam(value="tableId") Long tableId, HttpServletResponse response) throws IOException {
        Map codes = this.codegenService.generationCodes(tableId);
        String[] paths = codes.keySet().toArray(new String[0]);
        InputStream[] ins = (ByteArrayInputStream[])codes.values().stream().map(IoUtil::toUtf8Stream).toArray(ByteArrayInputStream[]::new);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipUtil.zip((OutputStream)outputStream, (String[])paths, (InputStream[])ins);
        ServletUtils.writeAttachment((HttpServletResponse)response, (String)"codegen.zip", (byte[])outputStream.toByteArray());
    }
}

