package com.primexpy.openapi.code;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

/**
 * AES CODER
 *
 * @author primexpy
 */
public class AESCoder extends CommonCoder {

    private static final int BLOCK_SIZE = 16;

    private AESCoder() {
    }

    public static String getRandomKey() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        byte[] result = getKeyEncode(encryptKey);
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(result, "AES"));
        return cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] getKeyEncode(String key) throws Exception {
        byte[] plaintext = new byte[BLOCK_SIZE];
        byte[] result = encryptMD5(key.getBytes());
        System.arraycopy(result, 0, plaintext, 0, BLOCK_SIZE);
        return plaintext;
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        byte[] result = aesEncryptToBytes(content, encryptKey);
        return encodeBase64(result);
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        byte[] result = getKeyEncode(decryptKey);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(result, "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes, StandardCharsets.UTF_8);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        byte[] result = decodeBase64(encryptStr);
        return encryptStr == null ? null : aesDecryptByBytes(result, decryptKey);
    }

}
