package com.primexpy.openapi.utils;

import com.primexpy.openapi.code.AESCoder;
import com.primexpy.openapi.code.RSACoder;
import com.primexpy.openapi.pojo.OpenApiKeyPair;
import com.primexpy.openapi.pojo.OpenApiBody;

import java.nio.charset.StandardCharsets;

/**
 * 工具类
 *
 * @author primexpy
 * @deprecated 为兼容老版本而存在，后续版本可能会删除它，推荐使用 OpenApiClient
 */
public class OpenApiUtil {

    /**
     * 签名
     *
     * @param openApiBody 请求体
     * @param priKey      私钥
     * @param salt        盐值
     * @return 签名字符串
     * @throws Exception 可能会发生异常，请考虑它
     */
    public static String sign(OpenApiBody openApiBody, String priKey, String salt) throws Exception {
        return RSACoder.sign(openApiBody.genSignStr(salt).getBytes(StandardCharsets.UTF_8), priKey);
    }

    /**
     * 验签
     *
     * @param openApiBody 请求体
     * @param pubKey      公钥
     * @param sign        签名
     * @param salt        盐值
     * @return 是否通过
     * @throws Exception 可能会发生异常，请考虑它
     */
    public static boolean verify(OpenApiBody openApiBody, String pubKey, String sign, String salt) throws Exception {
        return RSACoder.verify(openApiBody.genSignStr(salt).getBytes(StandardCharsets.UTF_8), pubKey, sign);
    }

    /**
     * 加密
     *
     * @param content 明文
     * @param pubKey  公钥
     * @return 加密body
     * @throws Exception 可能会发生异常，请考虑它
     */
    public static OpenApiBody encrypt(String content, String pubKey) throws Exception {
        String key = AESCoder.getRandomKey();
        String enValue = AESCoder.aesEncrypt(content, key);
        String enKey = RSACoder.encryptByPublicKey(key, pubKey);
        return new OpenApiBody(enKey, enValue);
    }

    /**
     * 解密
     *
     * @param openApiBody 加密body
     * @param priKey      私钥
     * @return 明文串
     * @throws Exception 可能会发生异常，请考虑它
     */
    public static String decrypt(OpenApiBody openApiBody, String priKey) throws Exception {
        String enKey = openApiBody.getKey();
        String deKey = RSACoder.decryptByPrivateKey(enKey, priKey);
        String enValue = openApiBody.getValue();
        return AESCoder.aesDecrypt(enValue, deKey);
    }

}
