/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.server.rest.client;

import de.factoryfx.data.merge.AttributeDiffInfo;
import de.factoryfx.data.merge.MergeDiffInfo;
import de.factoryfx.factory.FactoryBase;
import de.factoryfx.factory.datastorage.FactoryAndNewMetadata;
import de.factoryfx.factory.datastorage.StoredFactoryMetadata;
import de.factoryfx.factory.log.FactoryUpdateLog;
import de.factoryfx.server.rest.CheckUserResponse;
import de.factoryfx.server.rest.DiffForFactoryResponse;
import de.factoryfx.server.rest.UpdateCurrentFactoryRequest;
import de.factoryfx.server.rest.UserAwareRequest;
import de.factoryfx.server.rest.UserLocaleResponse;
import de.factoryfx.server.rest.client.RestClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class ApplicationServerRestClient<V, T extends FactoryBase<?, V>> {
    private final Class<T> factoryRootClass;
    private final RestClient restClient;
    private final String user;
    private final String passwordHash;
    static final Class<? extends ArrayList<StoredFactoryMetadata>> collectionOfStoredFactoryMetadataClass = new ArrayList<StoredFactoryMetadata>(){}.getClass();

    public ApplicationServerRestClient(RestClient restClient, Class<T> factoryRootClass, String user, String passwordHash) {
        this.restClient = restClient;
        this.factoryRootClass = factoryRootClass;
        this.user = user;
        this.passwordHash = passwordHash;
    }

    public FactoryUpdateLog updateCurrentFactory(FactoryAndNewMetadata<T> update, String comment) {
        UpdateCurrentFactoryRequest updateCurrentFactoryRequest = new UpdateCurrentFactoryRequest();
        updateCurrentFactoryRequest.comment = comment;
        updateCurrentFactoryRequest.factoryUpdate = update;
        return (FactoryUpdateLog)this.restClient.post("updateCurrentFactory", (Object)new UserAwareRequest(this.user, this.passwordHash, (Object)updateCurrentFactoryRequest), FactoryUpdateLog.class);
    }

    public MergeDiffInfo simulateUpdateCurrentFactory(FactoryAndNewMetadata<T> update) {
        return (MergeDiffInfo)this.restClient.post("simulateUpdateCurrentFactory", (Object)new UserAwareRequest(this.user, this.passwordHash, update), MergeDiffInfo.class);
    }

    public FactoryAndNewMetadata<T> prepareNewFactory() {
        FactoryAndNewMetadata currentFactory = (FactoryAndNewMetadata)this.restClient.post("prepareNewFactory", (Object)new UserAwareRequest(this.user, this.passwordHash, null), FactoryAndNewMetadata.class);
        return new FactoryAndNewMetadata((FactoryBase)currentFactory.root.internal().prepareUsableCopy(), currentFactory.metadata);
    }

    public MergeDiffInfo getDiff(StoredFactoryMetadata historyEntry) {
        return (MergeDiffInfo)this.restClient.post("diff", (Object)new UserAwareRequest(this.user, this.passwordHash, (Object)historyEntry), MergeDiffInfo.class);
    }

    public T getHistoryFactory(String id) {
        return (T)((FactoryBase)((FactoryBase)this.restClient.post("historyFactory", (Object)new UserAwareRequest(this.user, this.passwordHash, (Object)id), this.factoryRootClass)).internal().prepareUsableCopy());
    }

    public Collection<StoredFactoryMetadata> getHistoryFactoryList() {
        return (Collection)this.restClient.post("historyFactoryList", (Object)new UserAwareRequest(this.user, this.passwordHash, null), collectionOfStoredFactoryMetadataClass);
    }

    public V query(V visitor) {
        return (V)this.restClient.post("query", (Object)new UserAwareRequest(this.user, this.passwordHash, visitor), visitor.getClass());
    }

    public boolean checkUser() {
        CheckUserResponse response = (CheckUserResponse)this.restClient.post("checkUser", (Object)new UserAwareRequest(this.user, this.passwordHash, null), CheckUserResponse.class);
        return response.valid;
    }

    public Locale getLocale() {
        UserLocaleResponse response = (UserLocaleResponse)this.restClient.post("userLocale", (Object)new UserAwareRequest(this.user, this.passwordHash, null), UserLocaleResponse.class);
        return response.locale;
    }

    public FactoryUpdateLog revert(StoredFactoryMetadata historyFactory) {
        return (FactoryUpdateLog)this.restClient.post("revert", (Object)new UserAwareRequest(this.user, this.passwordHash, (Object)historyFactory), FactoryUpdateLog.class);
    }

    public List<AttributeDiffInfo> getSingleFactoryHistory(String factoryId) {
        return ((DiffForFactoryResponse)this.restClient.post((String)"diffForFactory", (Object)new UserAwareRequest((String)this.user, (String)this.passwordHash, (Object)factoryId), DiffForFactoryResponse.class)).diffs;
    }
}

