/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.server.rest;

import de.factoryfx.data.merge.MergeDiffInfo;
import de.factoryfx.factory.FactoryBase;
import de.factoryfx.factory.datastorage.FactoryAndNewMetadata;
import de.factoryfx.factory.datastorage.StoredFactoryMetadata;
import de.factoryfx.factory.log.FactoryUpdateLog;
import de.factoryfx.server.ApplicationServer;
import de.factoryfx.server.rest.CheckUserResponse;
import de.factoryfx.server.rest.DiffForFactoryResponse;
import de.factoryfx.server.rest.KeyResponse;
import de.factoryfx.server.rest.UpdateCurrentFactoryRequest;
import de.factoryfx.server.rest.UserAwareRequest;
import de.factoryfx.server.rest.UserLocaleResponse;
import de.factoryfx.user.AuthorizedUser;
import de.factoryfx.user.UserManagement;
import de.factoryfx.user.persistent.UserFactory;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="{parameter: adminui|applicationServer}")
public class ApplicationServerResource<V, L, T extends FactoryBase<L, V>> {
    private final ApplicationServer<V, L, T> applicationServer;
    private final UserManagement userManagement;
    private final Predicate<Optional<AuthorizedUser>> authorizedKeyUserEvaluator;

    public ApplicationServerResource(ApplicationServer<V, L, T> applicationServer, UserManagement userManagement, Predicate<Optional<AuthorizedUser>> authorizedKeyUserEvaluator) {
        this.applicationServer = applicationServer;
        this.userManagement = userManagement;
        this.authorizedKeyUserEvaluator = authorizedKeyUserEvaluator;
    }

    private Optional<AuthorizedUser> authenticate(UserAwareRequest<?> request) {
        if (this.userManagement.authorisationRequired()) {
            Optional authorizedUser = this.userManagement.authenticate(request.user, request.passwordHash);
            if (!authorizedUser.isPresent()) {
                throw new IllegalStateException("invalid user");
            }
            return authorizedUser;
        }
        return Optional.empty();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="updateCurrentFactory")
    public FactoryUpdateLog updateCurrentFactory(UserAwareRequest<UpdateCurrentFactoryRequest> update) {
        Function<String, Boolean> permissionChecker = this.authenticateAndGetPermissionChecker(update);
        return this.applicationServer.updateCurrentFactory(new FactoryAndNewMetadata((FactoryBase)((UpdateCurrentFactoryRequest)update.request).factoryUpdate.root.internal().prepareUsableCopy(), ((UpdateCurrentFactoryRequest)update.request).factoryUpdate.metadata), update.user, ((UpdateCurrentFactoryRequest)update.request).comment, permissionChecker);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="revert")
    public FactoryUpdateLog revert(UserAwareRequest<StoredFactoryMetadata> historyFactory) {
        this.authenticate(historyFactory);
        return this.applicationServer.revertTo((StoredFactoryMetadata)historyFactory.request, historyFactory.user);
    }

    private Function<String, Boolean> authenticateAndGetPermissionChecker(UserAwareRequest<?> request) {
        Optional<AuthorizedUser> authenticate = this.authenticate(request);
        Function<String, Boolean> permissionChecker = permission -> true;
        if (authenticate.isPresent()) {
            permissionChecker = permission -> ((AuthorizedUser)authenticate.get()).checkPermissionValid(permission);
        }
        return permissionChecker;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="simulateUpdateCurrentFactory")
    public MergeDiffInfo simulateUpdateCurrentFactory(UserAwareRequest<FactoryAndNewMetadata> request) {
        Function<String, Boolean> permissionChecker = this.authenticateAndGetPermissionChecker(request);
        return this.applicationServer.simulateUpdateCurrentFactory(new FactoryAndNewMetadata((FactoryBase)((FactoryAndNewMetadata)request.request).root.internal().prepareUsableCopy(), ((FactoryAndNewMetadata)request.request).metadata), permissionChecker);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="diff")
    public MergeDiffInfo getDiff(UserAwareRequest<StoredFactoryMetadata> request) {
        this.authenticate(request);
        return this.applicationServer.getDiffToPreviousVersion((StoredFactoryMetadata)request.request);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="prepareNewFactory")
    public FactoryAndNewMetadata prepareNewFactory(UserAwareRequest<Void> request) {
        this.authenticate(request);
        return this.applicationServer.prepareNewFactory();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="historyFactory")
    public Object getHistoryFactory(UserAwareRequest<String> request) {
        this.authenticate(request);
        return this.applicationServer.getHistoryFactory((String)request.request);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="historyFactoryList")
    public Collection<StoredFactoryMetadata> getHistoryFactoryList(UserAwareRequest<Void> request) {
        this.authenticate(request);
        return this.applicationServer.getHistoryFactoryList();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="query")
    public V query(UserAwareRequest<V> request) {
        this.authenticate(request);
        return (V)this.applicationServer.query(request.request);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="checkUser")
    public CheckUserResponse checkUser(UserAwareRequest<Void> request) {
        return new CheckUserResponse(this.userManagement.authenticate(request.user, request.passwordHash).isPresent());
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="userKey")
    public KeyResponse getUserKey(UserAwareRequest<Void> request) {
        if (this.authorizedKeyUserEvaluator.test(this.authenticate(request))) {
            return new KeyResponse(UserFactory.passwordKey);
        }
        return new KeyResponse("");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="userLocale")
    public UserLocaleResponse getUserLocale(UserAwareRequest<Void> request) {
        Optional<AuthorizedUser> authenticate = this.authenticate(request);
        return authenticate.map(authorizedUser -> new UserLocaleResponse(authorizedUser.locale)).orElseGet(() -> new UserLocaleResponse(Locale.ENGLISH));
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="diffForFactory")
    public DiffForFactoryResponse getDiffHistoryForFactory(UserAwareRequest<String> request) {
        this.authenticate(request);
        DiffForFactoryResponse diffForFactoryResponse = new DiffForFactoryResponse();
        diffForFactoryResponse.diffs = this.applicationServer.getDiffHistoryForFactory((String)request.request);
        return diffForFactoryResponse;
    }
}

