/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javascript.data.attributes.types;

import java.util.Collection;
import java.util.Map;
import javafx.util.Pair;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;

public class ScriptExecutor {
    private static final String NASHORN_SCRIPT_FILE_NAME = "javax.script.filename";
    private final NashornScriptEngine scriptEngine = (NashornScriptEngine)new NashornScriptEngineFactory().getScriptEngine();
    private final SimpleBindings bindings = new SimpleBindings();
    private final CompiledScript compiledScript;

    public ScriptExecutor(Collection<Pair<String, String>> libraries, String scriptName, String scriptCode, Map<String, Object> globalObjects) {
        this.bindings.putAll((Map<? extends String, ? extends Object>)globalObjects);
        this.scriptEngine.setBindings((Bindings)this.bindings, 100);
        libraries.forEach(p -> {
            this.bindings.put(NASHORN_SCRIPT_FILE_NAME, p.getKey());
            try {
                this.scriptEngine.eval((String)p.getValue());
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            this.bindings.put(NASHORN_SCRIPT_FILE_NAME, (Object)scriptName);
            this.compiledScript = this.scriptEngine.compile(scriptCode);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public Object execute(Map<String, Object> variables) {
        this.bindings.putAll((Map<? extends String, ? extends Object>)variables);
        try {
            this.scriptEngine.getContext().setBindings(this.bindings, 100);
            Object object = this.compiledScript.eval();
            return object;
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
        finally {
            variables.keySet().forEach(this.bindings::remove);
        }
    }
}

