/*
 * Decompiled with CFR 0.152.
 */
package de.factoryfx.javascript.data.attributes.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.javascript.jscomp.SourceFile;
import de.factoryfx.data.Data;
import de.factoryfx.data.attribute.AttributeChangeListener;
import de.factoryfx.data.attribute.ImmutableValueAttribute;
import de.factoryfx.javascript.data.attributes.types.DeclareJavaInput;
import de.factoryfx.javascript.data.attributes.types.Externs;
import de.factoryfx.javascript.data.attributes.types.Javascript;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.application.Platform;

public class JavascriptAttribute<A>
extends ImmutableValueAttribute<Javascript<A>, JavascriptAttribute<A>> {
    @JsonIgnore
    private final Supplier<List<? extends Data>> data;
    @JsonIgnore
    private final Class<A> apiClass;
    @JsonIgnore
    private final Function<List<? extends Data>, String> headerCreator = this::defaultCreateHeader;
    private Consumer<Runnable> runlaterExecutor = Platform::runLater;
    private DirtyTrackingThread dirtyTracking;

    public JavascriptAttribute(Supplier<List<? extends Data>> data, Class<A> apiClass) {
        super(Javascript.class.asSubclass(Javascript.class));
        this.data = data;
        this.apiClass = apiClass;
        this.set(new Javascript("", this.createHeader(), this.createHeaderApi()));
    }

    public boolean internal_mergeMatch(Javascript<A> value) {
        if (this.value == null && value == null) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return Objects.equals(((Javascript)this.value).getCode(), value.getCode());
    }

    public void internal_copyTo(JavascriptAttribute<A> copyAttribute, Function<Data, Data> dataCopyProvider) {
        if (copyAttribute.get() == null) {
            copyAttribute.set(new Javascript());
        } else {
            copyAttribute.set(new Javascript(((Javascript)copyAttribute.get()).getCode()));
        }
    }

    public List<SourceFile> internal_getExterns() {
        return Externs.get();
    }

    private String createHeaderApi() {
        DeclareJavaInput createDecl = new DeclareJavaInput();
        createDecl.declareVariable("api", this.apiClass);
        return createDecl.sourceScript();
    }

    private String createHeader() {
        return this.headerCreator.apply(this.data.get());
    }

    private String defaultCreateHeader(List<? extends Data> list) {
        StringBuilder sb = new StringBuilder();
        if (list.size() == 1) {
            sb.append("var data = ");
        } else {
            sb.append("var data = [");
        }
        int initialLen = sb.length();
        for (Data data : list) {
            if (data != null) {
                this.writeData(sb, data);
                sb.append(',');
                continue;
            }
            sb.append("null,");
        }
        if (sb.length() > initialLen) {
            sb.setLength(sb.length() - 1);
        }
        if (list.size() == 1) {
            sb.append(";\n");
        } else {
            sb.append("];\n");
        }
        return sb.toString();
    }

    private void writeData(StringBuilder sb, Data d) {
        sb.append("{");
        ObjectMapper mapper = new ObjectMapper();
        int oldLen = sb.length();
        d.internal().visitAttributesFlat((name, attribute) -> {
            try {
                Object value = attribute.get();
                sb.append("\"").append(name).append("\" : ");
                if (value instanceof Data) {
                    this.writeData(sb, (Data)value);
                } else {
                    sb.append(mapper.writeValueAsString(value));
                }
                sb.append(",");
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        if (sb.length() > oldLen) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
    }

    public Javascript<A> get() {
        Javascript currentValue = new Javascript(((Javascript)super.get()).getCode(), this.createHeader(), this.createHeaderApi());
        if (!currentValue.match((Javascript)super.get())) {
            this.set(currentValue);
        }
        return (Javascript)super.get();
    }

    void setRunlaterExecutorForTest(Consumer<Runnable> runlaterExecutor) {
        this.runlaterExecutor = runlaterExecutor;
    }

    void runLater(Runnable runnable) {
        this.runlaterExecutor.accept(runnable);
    }

    public void internal_addListener(AttributeChangeListener<Javascript<A>, JavascriptAttribute<A>> listener) {
        super.internal_addListener(listener);
        if (this.dirtyTracking == null) {
            this.dirtyTracking = new DirtyTrackingThread();
            this.dirtyTracking.setDaemon(true);
            this.dirtyTracking.start();
        }
    }

    public void internal_removeListener(AttributeChangeListener<Javascript<A>, JavascriptAttribute<A>> listener) {
        super.internal_removeListener(listener);
        if (this.listenersEmpty() && this.dirtyTracking != null) {
            this.dirtyTracking.stopTracking();
            this.dirtyTracking = null;
        }
    }

    public void internal_endUsage() {
        if (this.dirtyTracking != null) {
            this.dirtyTracking.stopTracking();
        }
        super.internal_endUsage();
    }

    class DirtyTrackingThread
    extends Thread {
        volatile boolean tracking = true;
        Javascript<A> previousValue = JavascriptAttribute.this.get();

        DirtyTrackingThread() {
        }

        @Override
        public void run() {
            super.run();
            while (this.tracking) {
                Object currentValue = JavascriptAttribute.this.get();
                if (!((Javascript)currentValue).getHeaderCode().equals(this.previousValue.getHeaderCode())) {
                    JavascriptAttribute.this.set(currentValue);
                }
                this.previousValue = currentValue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void stopTracking() {
            this.tracking = false;
        }
    }
}

