/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.javascript.data.attributes.types;

import com.google.common.io.ByteStreams;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DefaultExterns;
import com.google.javascript.jscomp.SourceFile;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Externs {
    private static final List<SourceFile> externs;

    public static List<SourceFile> get() {
        return externs;
    }

    static {
        try {
            ZipEntry entry;
            InputStream input = Externs.class.getResourceAsStream("/externs.zip");
            if (input == null) {
                input = Externs.class.getResourceAsStream("externs.zip");
            }
            ZipInputStream zip = new ZipInputStream(input);
            String envPrefix = CompilerOptions.Environment.CUSTOM.toString().toLowerCase() + "/";
            HashMap<String, SourceFile> mapFromExternsZip = new HashMap<String, SourceFile>();
            while ((entry = zip.getNextEntry()) != null) {
                String filename = entry.getName();
                if (filename.contains("/")) {
                    if (!filename.startsWith(envPrefix)) continue;
                    filename = filename.substring(envPrefix.length());
                }
                BufferedInputStream entryStream = new BufferedInputStream(ByteStreams.limit((InputStream)zip, (long)entry.getSize()));
                mapFromExternsZip.put(filename, SourceFile.fromInputStream((String)("externs.zip//" + filename), (InputStream)entryStream, (Charset)StandardCharsets.UTF_8));
            }
            externs = Collections.unmodifiableList(DefaultExterns.prepareExterns((CompilerOptions.Environment)CompilerOptions.Environment.CUSTOM, mapFromExternsZip));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

