/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.github.fluid_cloudnative.fluid.AlluxioCompTemplateSpec;
import com.github.fluid_cloudnative.fluid.AlluxioFuseSpec;
import com.github.fluid_cloudnative.fluid.Data;
import com.github.fluid_cloudnative.fluid.InitUsersSpec;
import com.github.fluid_cloudnative.fluid.Tieredstore;
import com.github.fluid_cloudnative.fluid.User;
import com.github.fluid_cloudnative.fluid.VersionSpec;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="AlluxioRuntimeSpec defines the desired state of AlluxioRuntime")
public class AlluxioRuntimeSpec {
    @SerializedName(value="alluxioVersion")
    private VersionSpec alluxioVersion = null;
    @SerializedName(value="apiGateway")
    private AlluxioCompTemplateSpec apiGateway = null;
    @SerializedName(value="data")
    private Data data = null;
    @SerializedName(value="disablePrometheus")
    private Boolean disablePrometheus = null;
    @SerializedName(value="fuse")
    private AlluxioFuseSpec fuse = null;
    @SerializedName(value="hadoopConfig")
    private String hadoopConfig = null;
    @SerializedName(value="initUsers")
    private InitUsersSpec initUsers = null;
    @SerializedName(value="jobMaster")
    private AlluxioCompTemplateSpec jobMaster = null;
    @SerializedName(value="jobWorker")
    private AlluxioCompTemplateSpec jobWorker = null;
    @SerializedName(value="jvmOptions")
    private List<String> jvmOptions = null;
    @SerializedName(value="master")
    private AlluxioCompTemplateSpec master = null;
    @SerializedName(value="properties")
    private Map<String, String> properties = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="runAs")
    private User runAs = null;
    @SerializedName(value="tieredstore")
    private Tieredstore tieredstore = null;
    @SerializedName(value="worker")
    private AlluxioCompTemplateSpec worker = null;

    public AlluxioRuntimeSpec alluxioVersion(VersionSpec alluxioVersion) {
        this.alluxioVersion = alluxioVersion;
        return this;
    }

    @ApiModelProperty(value="The version information that instructs fluid to orchestrate a particular version of Alluxio.")
    public VersionSpec getAlluxioVersion() {
        return this.alluxioVersion;
    }

    public void setAlluxioVersion(VersionSpec alluxioVersion) {
        this.alluxioVersion = alluxioVersion;
    }

    public AlluxioRuntimeSpec apiGateway(AlluxioCompTemplateSpec apiGateway) {
        this.apiGateway = apiGateway;
        return this;
    }

    @ApiModelProperty(value="Desired state for Alluxio API Gateway")
    public AlluxioCompTemplateSpec getApiGateway() {
        return this.apiGateway;
    }

    public void setApiGateway(AlluxioCompTemplateSpec apiGateway) {
        this.apiGateway = apiGateway;
    }

    public AlluxioRuntimeSpec data(Data data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="Management strategies for the dataset to which the runtime is bound")
    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public AlluxioRuntimeSpec disablePrometheus(Boolean disablePrometheus) {
        this.disablePrometheus = disablePrometheus;
        return this;
    }

    @ApiModelProperty(value="Disable monitoring for Alluxio Runtime Promethous is enabled by default")
    public Boolean isDisablePrometheus() {
        return this.disablePrometheus;
    }

    public void setDisablePrometheus(Boolean disablePrometheus) {
        this.disablePrometheus = disablePrometheus;
    }

    public AlluxioRuntimeSpec fuse(AlluxioFuseSpec fuse) {
        this.fuse = fuse;
        return this;
    }

    @ApiModelProperty(value="Desired state for Alluxio Fuse")
    public AlluxioFuseSpec getFuse() {
        return this.fuse;
    }

    public void setFuse(AlluxioFuseSpec fuse) {
        this.fuse = fuse;
    }

    public AlluxioRuntimeSpec hadoopConfig(String hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        return this;
    }

    @ApiModelProperty(value="Name of the configMap used to support HDFS configurations when using HDFS as Alluxio's UFS. The configMap must be in the same namespace with the AlluxioRuntime. The configMap should contain user-specific HDFS conf files in it. For now, only \"hdfs-site.xml\" and \"core-site.xml\" are supported. It must take the filename of the conf file as the key and content of the file as the value.")
    public String getHadoopConfig() {
        return this.hadoopConfig;
    }

    public void setHadoopConfig(String hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
    }

    public AlluxioRuntimeSpec initUsers(InitUsersSpec initUsers) {
        this.initUsers = initUsers;
        return this;
    }

    @ApiModelProperty(value="The spec of init users")
    public InitUsersSpec getInitUsers() {
        return this.initUsers;
    }

    public void setInitUsers(InitUsersSpec initUsers) {
        this.initUsers = initUsers;
    }

    public AlluxioRuntimeSpec jobMaster(AlluxioCompTemplateSpec jobMaster) {
        this.jobMaster = jobMaster;
        return this;
    }

    @ApiModelProperty(value="Desired state for Alluxio job master")
    public AlluxioCompTemplateSpec getJobMaster() {
        return this.jobMaster;
    }

    public void setJobMaster(AlluxioCompTemplateSpec jobMaster) {
        this.jobMaster = jobMaster;
    }

    public AlluxioRuntimeSpec jobWorker(AlluxioCompTemplateSpec jobWorker) {
        this.jobWorker = jobWorker;
        return this;
    }

    @ApiModelProperty(value="Desired state for Alluxio job Worker")
    public AlluxioCompTemplateSpec getJobWorker() {
        return this.jobWorker;
    }

    public void setJobWorker(AlluxioCompTemplateSpec jobWorker) {
        this.jobWorker = jobWorker;
    }

    public AlluxioRuntimeSpec jvmOptions(List<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    public AlluxioRuntimeSpec addJvmOptionsItem(String jvmOptionsItem) {
        if (this.jvmOptions == null) {
            this.jvmOptions = new ArrayList<String>();
        }
        this.jvmOptions.add(jvmOptionsItem);
        return this;
    }

    @ApiModelProperty(value="Options for JVM")
    public List<String> getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(List<String> jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    public AlluxioRuntimeSpec master(AlluxioCompTemplateSpec master) {
        this.master = master;
        return this;
    }

    @ApiModelProperty(value="Desired state for Alluxio master")
    public AlluxioCompTemplateSpec getMaster() {
        return this.master;
    }

    public void setMaster(AlluxioCompTemplateSpec master) {
        this.master = master;
    }

    public AlluxioRuntimeSpec properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public AlluxioRuntimeSpec putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Configurable properties for Alluxio system. <br> Refer to <a href=\"https://docs.alluxio.io/os/user/stable/en/reference/Properties-List.html\">Alluxio Configuration Properties</a> for more info")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public AlluxioRuntimeSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="The replicas of the worker, need to be specified")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public AlluxioRuntimeSpec runAs(User runAs) {
        this.runAs = runAs;
        return this;
    }

    @ApiModelProperty(value="Manage the user to run Alluxio Runtime")
    public User getRunAs() {
        return this.runAs;
    }

    public void setRunAs(User runAs) {
        this.runAs = runAs;
    }

    public AlluxioRuntimeSpec tieredstore(Tieredstore tieredstore) {
        this.tieredstore = tieredstore;
        return this;
    }

    @ApiModelProperty(value="Tiered storage used by Alluxio")
    public Tieredstore getTieredstore() {
        return this.tieredstore;
    }

    public void setTieredstore(Tieredstore tieredstore) {
        this.tieredstore = tieredstore;
    }

    public AlluxioRuntimeSpec worker(AlluxioCompTemplateSpec worker) {
        this.worker = worker;
        return this;
    }

    @ApiModelProperty(value="Desired state for Alluxio worker")
    public AlluxioCompTemplateSpec getWorker() {
        return this.worker;
    }

    public void setWorker(AlluxioCompTemplateSpec worker) {
        this.worker = worker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlluxioRuntimeSpec alluxioRuntimeSpec = (AlluxioRuntimeSpec)o;
        return Objects.equals(this.alluxioVersion, alluxioRuntimeSpec.alluxioVersion) && Objects.equals(this.apiGateway, alluxioRuntimeSpec.apiGateway) && Objects.equals(this.data, alluxioRuntimeSpec.data) && Objects.equals(this.disablePrometheus, alluxioRuntimeSpec.disablePrometheus) && Objects.equals(this.fuse, alluxioRuntimeSpec.fuse) && Objects.equals(this.hadoopConfig, alluxioRuntimeSpec.hadoopConfig) && Objects.equals(this.initUsers, alluxioRuntimeSpec.initUsers) && Objects.equals(this.jobMaster, alluxioRuntimeSpec.jobMaster) && Objects.equals(this.jobWorker, alluxioRuntimeSpec.jobWorker) && Objects.equals(this.jvmOptions, alluxioRuntimeSpec.jvmOptions) && Objects.equals(this.master, alluxioRuntimeSpec.master) && Objects.equals(this.properties, alluxioRuntimeSpec.properties) && Objects.equals(this.replicas, alluxioRuntimeSpec.replicas) && Objects.equals(this.runAs, alluxioRuntimeSpec.runAs) && Objects.equals(this.tieredstore, alluxioRuntimeSpec.tieredstore) && Objects.equals(this.worker, alluxioRuntimeSpec.worker);
    }

    public int hashCode() {
        return Objects.hash(this.alluxioVersion, this.apiGateway, this.data, this.disablePrometheus, this.fuse, this.hadoopConfig, this.initUsers, this.jobMaster, this.jobWorker, this.jvmOptions, this.master, this.properties, this.replicas, this.runAs, this.tieredstore, this.worker);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlluxioRuntimeSpec {\n");
        sb.append("    alluxioVersion: ").append(this.toIndentedString(this.alluxioVersion)).append("\n");
        sb.append("    apiGateway: ").append(this.toIndentedString(this.apiGateway)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    disablePrometheus: ").append(this.toIndentedString(this.disablePrometheus)).append("\n");
        sb.append("    fuse: ").append(this.toIndentedString(this.fuse)).append("\n");
        sb.append("    hadoopConfig: ").append(this.toIndentedString(this.hadoopConfig)).append("\n");
        sb.append("    initUsers: ").append(this.toIndentedString(this.initUsers)).append("\n");
        sb.append("    jobMaster: ").append(this.toIndentedString(this.jobMaster)).append("\n");
        sb.append("    jobWorker: ").append(this.toIndentedString(this.jobWorker)).append("\n");
        sb.append("    jvmOptions: ").append(this.toIndentedString(this.jvmOptions)).append("\n");
        sb.append("    master: ").append(this.toIndentedString(this.master)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    runAs: ").append(this.toIndentedString(this.runAs)).append("\n");
        sb.append("    tieredstore: ").append(this.toIndentedString(this.tieredstore)).append("\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

