/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.proto.Meta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Condition explains the transitions on phase")
public class Condition {
    @SerializedName(value="lastProbeTime")
    private Meta.Time lastProbeTime = null;
    @SerializedName(value="lastTransitionTime")
    private Meta.Time lastTransitionTime = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="type")
    private String type = null;

    public Condition lastProbeTime(Meta.Time lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
        return this;
    }

    @ApiModelProperty(value="LastProbeTime describes last time this condition was updated.")
    public Meta.Time getLastProbeTime() {
        return this.lastProbeTime;
    }

    public void setLastProbeTime(Meta.Time lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
    }

    public Condition lastTransitionTime(Meta.Time lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @ApiModelProperty(value="LastTransitionTime describes last time the condition transitioned from one status to another.")
    public Meta.Time getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(Meta.Time lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public Condition message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="Message is a human-readable message indicating details about the transition")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Condition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Reason for the condition's last transition")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Condition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the condition, one of `True`, `False` or `Unknown`")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Condition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of condition, either `Complete` or `Failed`")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.lastProbeTime, condition.lastProbeTime) && Objects.equals(this.lastTransitionTime, condition.lastTransitionTime) && Objects.equals(this.message, condition.message) && Objects.equals(this.reason, condition.reason) && Objects.equals(this.status, condition.status) && Objects.equals(this.type, condition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastProbeTime, this.lastTransitionTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    lastProbeTime: ").append(this.toIndentedString(this.lastProbeTime)).append("\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

