/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.github.fluid_cloudnative.fluid.CacheableNodeAffinity;
import com.github.fluid_cloudnative.fluid.DataRestoreLocation;
import com.github.fluid_cloudnative.fluid.Mount;
import com.github.fluid_cloudnative.fluid.Runtime;
import com.github.fluid_cloudnative.fluid.User;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Toleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DatasetSpec defines the desired state of Dataset")
public class DatasetSpec {
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    @SerializedName(value="dataRestoreLocation")
    private DataRestoreLocation dataRestoreLocation = null;
    @SerializedName(value="mounts")
    private List<Mount> mounts = null;
    @SerializedName(value="nodeAffinity")
    private CacheableNodeAffinity nodeAffinity = null;
    @SerializedName(value="owner")
    private User owner = null;
    @SerializedName(value="placement")
    private String placement = null;
    @SerializedName(value="runtimes")
    private List<Runtime> runtimes = null;
    @SerializedName(value="tolerations")
    private List<V1Toleration> tolerations = null;

    public DatasetSpec accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public DatasetSpec addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @ApiModelProperty(value="AccessModes contains all ways the volume backing the PVC can be mounted")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public DatasetSpec dataRestoreLocation(DataRestoreLocation dataRestoreLocation) {
        this.dataRestoreLocation = dataRestoreLocation;
        return this;
    }

    @ApiModelProperty(value="DataRestoreLocation is the location to load data of dataset  been backuped")
    public DataRestoreLocation getDataRestoreLocation() {
        return this.dataRestoreLocation;
    }

    public void setDataRestoreLocation(DataRestoreLocation dataRestoreLocation) {
        this.dataRestoreLocation = dataRestoreLocation;
    }

    public DatasetSpec mounts(List<Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    public DatasetSpec addMountsItem(Mount mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<Mount>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @ApiModelProperty(value="Mount Points to be mounted on Alluxio.")
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<Mount> mounts) {
        this.mounts = mounts;
    }

    public DatasetSpec nodeAffinity(CacheableNodeAffinity nodeAffinity) {
        this.nodeAffinity = nodeAffinity;
        return this;
    }

    @ApiModelProperty(value="NodeAffinity defines constraints that limit what nodes this dataset can be cached to. This field influences the scheduling of pods that use the cached dataset.")
    public CacheableNodeAffinity getNodeAffinity() {
        return this.nodeAffinity;
    }

    public void setNodeAffinity(CacheableNodeAffinity nodeAffinity) {
        this.nodeAffinity = nodeAffinity;
    }

    public DatasetSpec owner(User owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(value="The owner of the dataset")
    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public DatasetSpec placement(String placement) {
        this.placement = placement;
        return this;
    }

    @ApiModelProperty(value="Manage switch for opening Multiple datasets single node deployment or not")
    public String getPlacement() {
        return this.placement;
    }

    public void setPlacement(String placement) {
        this.placement = placement;
    }

    public DatasetSpec runtimes(List<Runtime> runtimes) {
        this.runtimes = runtimes;
        return this;
    }

    public DatasetSpec addRuntimesItem(Runtime runtimesItem) {
        if (this.runtimes == null) {
            this.runtimes = new ArrayList<Runtime>();
        }
        this.runtimes.add(runtimesItem);
        return this;
    }

    @ApiModelProperty(value="Runtimes for supporting dataset (e.g. AlluxioRuntime)")
    public List<Runtime> getRuntimes() {
        return this.runtimes;
    }

    public void setRuntimes(List<Runtime> runtimes) {
        this.runtimes = runtimes;
    }

    public DatasetSpec tolerations(List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public DatasetSpec addTolerationsItem(V1Toleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1Toleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @ApiModelProperty(value="If specified, the pod's tolerations.")
    public List<V1Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetSpec datasetSpec = (DatasetSpec)o;
        return Objects.equals(this.accessModes, datasetSpec.accessModes) && Objects.equals(this.dataRestoreLocation, datasetSpec.dataRestoreLocation) && Objects.equals(this.mounts, datasetSpec.mounts) && Objects.equals(this.nodeAffinity, datasetSpec.nodeAffinity) && Objects.equals(this.owner, datasetSpec.owner) && Objects.equals(this.placement, datasetSpec.placement) && Objects.equals(this.runtimes, datasetSpec.runtimes) && Objects.equals(this.tolerations, datasetSpec.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataRestoreLocation, this.mounts, this.nodeAffinity, this.owner, this.placement, this.runtimes, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetSpec {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    dataRestoreLocation: ").append(this.toIndentedString(this.dataRestoreLocation)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    nodeAffinity: ").append(this.toIndentedString(this.nodeAffinity)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    placement: ").append(this.toIndentedString(this.placement)).append("\n");
        sb.append("    runtimes: ").append(this.toIndentedString(this.runtimes)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

