/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="JindoFuseSpec is a description of the Jindo Fuse")
public class JindoFuseSpec {
    @SerializedName(value="args")
    private List<String> args = null;
    @SerializedName(value="env")
    private Map<String, String> env = null;
    @SerializedName(value="global")
    private Boolean global = null;
    @SerializedName(value="image")
    private String image = null;
    @SerializedName(value="imagePullPolicy")
    private String imagePullPolicy = null;
    @SerializedName(value="imageTag")
    private String imageTag = null;
    @SerializedName(value="nodeSelector")
    private Map<String, String> nodeSelector = null;
    @SerializedName(value="properties")
    private Map<String, String> properties = null;
    @SerializedName(value="resources")
    private V1ResourceRequirements resources = null;

    public JindoFuseSpec args(List<String> args) {
        this.args = args;
        return this;
    }

    public JindoFuseSpec addArgsItem(String argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(argsItem);
        return this;
    }

    @ApiModelProperty(value="Arguments that will be passed to Jindo Fuse")
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public JindoFuseSpec env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public JindoFuseSpec putEnvItem(String key, String envItem) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(key, envItem);
        return this;
    }

    @ApiModelProperty(value="Environment variables that will be used by Jindo Fuse")
    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public JindoFuseSpec global(Boolean global) {
        this.global = global;
        return this;
    }

    @ApiModelProperty(value="If the fuse client should be deployed in global mode, otherwise the affinity should be considered")
    public Boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(Boolean global) {
        this.global = global;
    }

    public JindoFuseSpec image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(value="Image for Jindo Fuse(e.g. jindo/jindo-fuse)")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public JindoFuseSpec imagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    @ApiModelProperty(value="One of the three policies: `Always`, `IfNotPresent`, `Never`")
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public JindoFuseSpec imageTag(String imageTag) {
        this.imageTag = imageTag;
        return this;
    }

    @ApiModelProperty(value="Image Tag for Jindo Fuse(e.g. 2.3.0-SNAPSHOT)")
    public String getImageTag() {
        return this.imageTag;
    }

    public void setImageTag(String imageTag) {
        this.imageTag = imageTag;
    }

    public JindoFuseSpec nodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public JindoFuseSpec putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @ApiModelProperty(value="NodeSelector is a selector which must be true for the fuse client to fit on a node, this option only effect when global is enabled")
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public JindoFuseSpec properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public JindoFuseSpec putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Configurable properties for Jindo System. <br>")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public JindoFuseSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="Resources that will be requested by Jindo Fuse. <br> <br> Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JindoFuseSpec jindoFuseSpec = (JindoFuseSpec)o;
        return Objects.equals(this.args, jindoFuseSpec.args) && Objects.equals(this.env, jindoFuseSpec.env) && Objects.equals(this.global, jindoFuseSpec.global) && Objects.equals(this.image, jindoFuseSpec.image) && Objects.equals(this.imagePullPolicy, jindoFuseSpec.imagePullPolicy) && Objects.equals(this.imageTag, jindoFuseSpec.imageTag) && Objects.equals(this.nodeSelector, jindoFuseSpec.nodeSelector) && Objects.equals(this.properties, jindoFuseSpec.properties) && Objects.equals(this.resources, jindoFuseSpec.resources);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.env, this.global, this.image, this.imagePullPolicy, this.imageTag, this.nodeSelector, this.properties, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JindoFuseSpec {\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    global: ").append(this.toIndentedString(this.global)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imagePullPolicy: ").append(this.toIndentedString(this.imagePullPolicy)).append("\n");
        sb.append("    imageTag: ").append(this.toIndentedString(this.imageTag)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

